import { DeviceTelemetryType } from '../../Device/Telemetry/DeviceTelemetryType';
import { FrontCapabilities } from '../Capabilities/FrontCapability';
import { ManagementCapabilities } from '../Capabilities/ManagementCapabilities';
import { InputSource } from '../Input/InputSource';
import { NetworkInterfaces } from '../Network/NetworkInterface';
import Orientation from '../Resolution/Orientation';
import { ResolutionItem } from '../Resolution/ResolutionList';
import VideoOrientation from '../Resolution/VideoOrientation';
import { ConnectionMethod, PowerActionsScheduleSettings, ProprietaryTimerSettings, TimerSettings } from '../Settings/DeviceSettings';
import IStorageUnit from '../Storage/StorageType';
import { AutoRecoveryDisabled, AutoRecoveryEnabled, PeerRecoveryDisabled, PeerRecoveryEnabled } from './Recovery';
import { DeviceFeatureFlag } from '../FeatureFlag';
/**
 * Monitoring log data is a generic type used to store telemetry data from devices.
 * It's usually stored as a time series in database like MongoDB or as a last value in database like MongoDB or Redis.
 * Some of those items can be managed from server on the device and those should have its same named alternative DeviceSettings.
 */
export type MonitoringLogData = {
    [DeviceTelemetryType.DISPLAY_SETTING]: {
        backlight: number;
        contrast: number;
        sharpness: number;
        maxTemperature: number;
    };
    [DeviceTelemetryType.INPUT_SOURCE]: {
        /**
         * It may be arbitrary platform-dependent string but common values are listed in enumeration.
         */
        inputSource: InputSource | string;
    };
    [DeviceTelemetryType.VOLUME]: {
        volume: number;
    };
    [DeviceTelemetryType.BRIGHTNESS]: {
        brightness: number;
    };
    [DeviceTelemetryType.TIMERS]: TimerSettings[];
    [DeviceTelemetryType.PROPRIETARY_TIMERS]: ProprietaryTimerSettings[];
    [DeviceTelemetryType.RESOLUTION]: ResolutionItem;
    [DeviceTelemetryType.ORIENTATION]: {
        orientation: Orientation;
        videoOrientation?: VideoOrientation;
    };
    [DeviceTelemetryType.REMOTE_CONTROL]: {
        enabled: boolean;
    };
    [DeviceTelemetryType.APPLICATION_VERSION]: {
        version: string;
        /** @deprecated It's only available in mongodb database for filtering purposes */
        versionNumber?: number;
    };
    [DeviceTelemetryType.FRONT_DISPLAY_VERSION]: {
        version: string;
        versionNumber: number;
    };
    [DeviceTelemetryType.FIRMWARE_VERSION]: {
        version: string;
    };
    [DeviceTelemetryType.DEBUG]: {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    };
    [DeviceTelemetryType.DATETIME]: {
        timezone: string | null;
        ntpServer: string | null;
    };
    [DeviceTelemetryType.POWER_ACTIONS_SCHEDULE]: PowerActionsScheduleSettings[];
    [DeviceTelemetryType.TEMPERATURE]: {
        temperature: number;
    };
    [DeviceTelemetryType.OFFLINE_RANGE]: {
        since: Date;
        until: Date;
    };
    [DeviceTelemetryType.ONLINE_STATUS]: {
        online: boolean;
    };
    [DeviceTelemetryType.BUNDLED_APPLET]: {
        appletUid: string;
        appletVersion: string;
        config: {
            [key: string]: string;
        };
    } | null;
    [DeviceTelemetryType.PROXY]: {
        enabled: boolean;
        uri: string | null;
    };
    [DeviceTelemetryType.WIFI_STRENGTH]: {
        strength: number;
    };
    [DeviceTelemetryType.AUTO_RECOVERY]: AutoRecoveryEnabled | AutoRecoveryDisabled;
    [DeviceTelemetryType.PEER_RECOVERY]: PeerRecoveryEnabled | PeerRecoveryDisabled;
    [DeviceTelemetryType.MANAGEMENT_CAPABILITIES]: {
        capable: ManagementCapabilities[];
    };
    [DeviceTelemetryType.FRONT_CAPABILITIES]: {
        capable: FrontCapabilities[];
    };
    [DeviceTelemetryType.CONNECTION_METHOD]: ConnectionMethod;
    [DeviceTelemetryType.EXTENDED_MANAGEMENT]: {
        url: string | null;
    };
    [DeviceTelemetryType.NETWORK_INTERFACES]: NetworkInterfaces[];
    [DeviceTelemetryType.DISPLAY_POWER_ON]: {
        powerOn: boolean;
    };
    [DeviceTelemetryType.STORAGE]: {
        storageUnits: IStorageUnit[];
    };
    [DeviceTelemetryType.APP_MODULES]: {
        management: boolean;
        front: boolean;
    };
    [DeviceTelemetryType.FEATURE_FLAGS]: {
        supported: DeviceFeatureFlag[];
    };
    [DeviceTelemetryType.CRYPTOGRAPHIC_KEY]: {
        publicKey: string;
        hash: string;
        algorithm: string;
        validUntil: Date;
        validFrom: Date;
    };
};
