"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurationDefinitionSchema = exports.ConfigurationDefinitionSchemas = exports.BaseConfigurationDefinitionSchema = exports.ValueType = void 0;
const zod_1 = require("zod");
exports.ValueType = zod_1.z.enum(['string', 'URL', 'enum', 'number', 'secret', 'unknown']);
exports.BaseConfigurationDefinitionSchema = zod_1.z.object({
    name: zod_1.z.string(),
    valueType: zod_1.z.string(),
    placeholder: zod_1.z.string().optional(),
    description: zod_1.z.string().optional(),
    mandatory: zod_1.z.boolean().optional(),
});
exports.ConfigurationDefinitionSchemas = {
    string: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.string),
    }),
    URL: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.URL),
    }),
    enum: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.enum),
        list: zod_1.z.array(zod_1.z.union([zod_1.z.string(), zod_1.z.number()])),
    }),
    number: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.number),
        min: zod_1.z.number().optional(),
        max: zod_1.z.number().optional(),
    }),
    secret: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.secret),
    }),
    unknown: exports.BaseConfigurationDefinitionSchema.extend({
        valueType: zod_1.z.literal(exports.ValueType.Enum.unknown),
    }),
};
/**
 * Configuration definition of the applet versions and custom script version.
 * It can be optionally used to document and eventually validates the inputs of configuration.
 */
exports.ConfigurationDefinitionSchema = zod_1.z.array(zod_1.z.union([
    exports.ConfigurationDefinitionSchemas.string,
    exports.ConfigurationDefinitionSchemas.URL,
    exports.ConfigurationDefinitionSchemas.enum,
    exports.ConfigurationDefinitionSchemas.number,
    exports.ConfigurationDefinitionSchemas.secret,
    exports.ConfigurationDefinitionSchemas.unknown,
]));
