import { z } from 'zod';
export declare const ValueType: z.ZodEnum<["string", "URL", "enum", "number", "secret", "unknown"]>;
export declare const BaseConfigurationDefinitionSchema: z.ZodObject<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    name: string;
    valueType: string;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: string;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export declare const ConfigurationDefinitionSchemas: {
    string: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"string">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "string";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "string";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
    URL: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"URL">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "URL";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "URL";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
    enum: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"enum">;
        list: z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "enum";
        list: (string | number)[];
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "enum";
        list: (string | number)[];
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
    number: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"number">;
        min: z.ZodOptional<z.ZodNumber>;
        max: z.ZodOptional<z.ZodNumber>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "number";
        max?: number | undefined;
        min?: number | undefined;
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "number";
        max?: number | undefined;
        min?: number | undefined;
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
    secret: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"secret">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "secret";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "secret";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
    unknown: z.ZodObject<z.objectUtil.extendShape<{
        name: z.ZodString;
        valueType: z.ZodString;
        placeholder: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        mandatory: z.ZodOptional<z.ZodBoolean>;
    }, {
        valueType: z.ZodLiteral<"unknown">;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        valueType: "unknown";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }, {
        name: string;
        valueType: "unknown";
        description?: string | undefined;
        mandatory?: boolean | undefined;
        placeholder?: string | undefined;
    }>;
};
/**
 * Configuration definition of the applet versions and custom script version.
 * It can be optionally used to document and eventually validates the inputs of configuration.
 */
export declare const ConfigurationDefinitionSchema: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"string">;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "string";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "string";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"URL">;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "URL";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "URL";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"enum">;
    list: z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "enum";
    list: (string | number)[];
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "enum";
    list: (string | number)[];
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"number">;
    min: z.ZodOptional<z.ZodNumber>;
    max: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "number";
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "number";
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"secret">;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "secret";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "secret";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    valueType: z.ZodString;
    placeholder: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
}, {
    valueType: z.ZodLiteral<"unknown">;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: "unknown";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: "unknown";
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>]>, "many">;
export type ConfigurationDefinition = z.infer<typeof ConfigurationDefinitionSchema>;
