import { DeviceFeatureFlag } from '../Device/FeatureFlag';
import { SocketDriver } from '../Device/socketDriver';
/**
 * When some values are omitted (undefined) keep original value.
 * null value set the value to nothing (device default)
 */
export interface ConfigValues {
    platformUri?: string | null;
    staticBaseUrl?: string | null;
    uploadBaseUrl?: string | null;
    weinreUri?: string | null;
    extendedManagementUrl?: string | null;
    socketDriver?: SocketDriver | null;
    /**
     * Map of feature flags and their enabled/disabled state
     * If a feature flag is not present in the map, the app decides a reasonable default
     */
    featureFlags?: Partial<Record<DeviceFeatureFlag, boolean>> | null;
}
