"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidApplicationVersion = void 0;
exports.default = isSemverWithVersionValid;
const isValidNumericOperator_1 = require("../../Validation/isValidNumericOperator");
const Validation_1 = require("../../Validation/Validation");
const isValidSemVer_1 = require("../../Validation/isValidSemVer");
function isSemverWithVersionValid(version) {
    const validation = (0, Validation_1.createValidation)(version);
    const isValidArray = Array.isArray(version);
    if (isValidArray) {
        const versionArray = Array.from(version);
        const isValidNumeric = (0, isValidNumericOperator_1.default)(versionArray[0]);
        const isValidApplicationVersion = (0, isValidSemVer_1.default)(versionArray[1]);
        if (isValidNumeric.hasErrors() || !isValidApplicationVersion) {
            validation.addError(new InvalidApplicationVersion(version));
        }
    }
    else {
        validation.addError(new InvalidApplicationVersion(version));
    }
    return validation.getOutput();
}
class InvalidApplicationVersion extends Error {
    constructor(version) {
        super(`Application version is not valid : ${version}`);
    }
}
exports.InvalidApplicationVersion = InvalidApplicationVersion;
