"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidOrganizationUids = exports.InvalidDescription = void 0;
exports.default = isAlertRuleUpdatableValid;
const Validation_1 = require("../../Validation/Validation");
const validateAlertType_1 = require("./validateAlertType");
const validateAlertFilter_1 = require("./validateAlertFilter");
const validateThreshold_1 = require("./validateThreshold");
const validateAlertPeriodicity_1 = require("./validateAlertPeriodicity");
const validateAlertAction_1 = require("./validateAlertAction");
const validateAlertFilter_2 = require("./validateAlertFilter");
const validateAlertConditions_1 = require("./validateAlertConditions");
function isAlertRuleUpdatableValid(alertRuleUpdatableInput) {
    var _a;
    const validation = (0, Validation_1.createValidation)({});
    const alertRuleUpdatable = (_a = alertRuleUpdatableInput) !== null && _a !== void 0 ? _a : {};
    if (alertRuleUpdatable.alertType) {
        const isValidAlertType = (0, validateAlertType_1.default)(alertRuleUpdatable.alertType);
        if (isValidAlertType.hasErrors()) {
            validation.addError(...isValidAlertType.getErrors());
        }
    }
    if (alertRuleUpdatable.name) {
        const isValidName = typeof alertRuleUpdatable.name === 'string' && alertRuleUpdatable.name.length > 1;
        if (!isValidName) {
            validation.addError(new validateAlertFilter_2.InvalidName(alertRuleUpdatable.name));
        }
    }
    if (alertRuleUpdatable.description) {
        const isValidDescription = typeof alertRuleUpdatable.description === 'string' && alertRuleUpdatable.description.length > 1;
        if (!isValidDescription) {
            validation.addError(new InvalidDescription(alertRuleUpdatable.description));
        }
    }
    if (alertRuleUpdatable.organizationUids) {
        const isValidObject = Array.isArray(alertRuleUpdatable.organizationUids);
        const hasValidElement = alertRuleUpdatable.organizationUids.length > 0 &&
            alertRuleUpdatable.organizationUids.every((element) => typeof element === 'string' && element.length > 5);
        if (!isValidObject || !hasValidElement) {
            validation.addError(new InvalidOrganizationUids(alertRuleUpdatable.organizationUids));
        }
    }
    if (alertRuleUpdatable.filter) {
        const isValidFilter = (0, validateAlertFilter_1.default)(alertRuleUpdatable.filter);
        if (isValidFilter.hasErrors()) {
            validation.addError(...isValidFilter.getErrors());
        }
    }
    if (alertRuleUpdatable.conditions) {
        const validConditions = (0, validateAlertConditions_1.default)(alertRuleUpdatable.conditions, alertRuleUpdatable.alertType);
        if (validConditions.hasErrors()) {
            validation.addError(...validConditions.getErrors());
        }
    }
    if (alertRuleUpdatable.threshold) {
        const isValidThreshold = (0, validateThreshold_1.default)(alertRuleUpdatable.threshold);
        if (isValidThreshold.hasErrors()) {
            validation.addError(...isValidThreshold.getErrors());
        }
    }
    if (alertRuleUpdatable.periodicity) {
        const isValidPeriodicity = (0, validateAlertPeriodicity_1.default)(alertRuleUpdatable.periodicity);
        if (isValidPeriodicity.hasErrors()) {
            validation.addError(...isValidPeriodicity.getErrors());
        }
    }
    if (alertRuleUpdatable.action) {
        const isValidAlertAction = (0, validateAlertAction_1.default)(alertRuleUpdatable.action);
        if (isValidAlertAction.hasErrors()) {
            validation.addError(...isValidAlertAction.getErrors());
        }
    }
    return validation.getOutput();
}
class InvalidDescription extends Error {
    constructor(type) {
        super(`Description is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidDescription = InvalidDescription;
class InvalidOrganizationUids extends Error {
    constructor(type) {
        super(`OrganizationUids is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidOrganizationUids = InvalidOrganizationUids;
