"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidUntilTimeInAlertPeriodicity = exports.InvalidUntilWeekdayInAlertPeriodicity = exports.InvalidSinceTimeInAlertPeriodicity = exports.InvalidSinceWeekdayInAlertPeriodicity = exports.UnknownAlertPeriodicityActiveTimeWindowType = exports.InvalidAlertPeriodicityActiveTimeWindowsType = exports.InvalidAlertPeriodicityInterval = exports.InvalidAlertPeriodicityInput = exports.periodicityIntervalValues = exports.activeTimeWindowType = void 0;
exports.default = isAlertPeriodicityValid;
const Validation_1 = require("../../Validation/Validation");
const isValidWeekday_1 = require("../../Device/Time/Validation/isValidWeekday");
const isValidTime_1 = require("../../Device/Time/Validation/isValidTime");
const getKeys_1 = require("../../Validation/getKeys");
exports.activeTimeWindowType = ['week'];
exports.periodicityIntervalValues = {
    min: 30,
    max: 3600,
};
function isAlertPeriodicityValid(periodicity) {
    var _a;
    const validation = (0, Validation_1.createValidation)(periodicity);
    const alertPeriodicity = (_a = periodicity) !== null && _a !== void 0 ? _a : null;
    const isValidObject = typeof alertPeriodicity === 'object' &&
        (0, getKeys_1.default)(alertPeriodicity).includes('interval') &&
        (0, getKeys_1.default)(alertPeriodicity).includes('activeTimeWindows');
    if (isValidObject) {
        const isIntervalOfValidType = Number.isInteger(alertPeriodicity.interval);
        const isIntervalInRange = alertPeriodicity.interval >= exports.periodicityIntervalValues.min && alertPeriodicity.interval <= exports.periodicityIntervalValues.max;
        if (!isIntervalInRange || !isIntervalOfValidType) {
            validation.addError(new InvalidAlertPeriodicityInterval(alertPeriodicity.interval));
        }
        const isActiveTimeWindowsOfValidType = Array.isArray(alertPeriodicity.activeTimeWindows);
        if (isActiveTimeWindowsOfValidType) {
            for (const activeTimeWindow of alertPeriodicity.activeTimeWindows) {
                switch (activeTimeWindow.type) {
                    case 'week': {
                        const isValidSinceWeekday = (0, isValidWeekday_1.default)(activeTimeWindow.sinceWeekday);
                        if (!isValidSinceWeekday) {
                            validation.addError(new InvalidSinceWeekdayInAlertPeriodicity(activeTimeWindow.sinceWeekday));
                        }
                        const isValidSinceTime = (0, isValidTime_1.default)(activeTimeWindow.sinceTime);
                        if (!isValidSinceTime) {
                            validation.addError(new InvalidSinceTimeInAlertPeriodicity(activeTimeWindow.sinceTime));
                        }
                        const isValidUntilWeekday = (0, isValidWeekday_1.default)(activeTimeWindow.untilWeekday);
                        if (!isValidUntilWeekday) {
                            validation.addError(new InvalidUntilWeekdayInAlertPeriodicity(activeTimeWindow.untilWeekday));
                        }
                        const isValidUntilTime = (0, isValidTime_1.default)(activeTimeWindow.untilTime);
                        if (!isValidUntilTime) {
                            validation.addError(new InvalidUntilTimeInAlertPeriodicity(activeTimeWindow.untilTime));
                        }
                        break;
                    }
                    default:
                        validation.addError(new UnknownAlertPeriodicityActiveTimeWindowType(activeTimeWindow.type));
                }
            }
        }
        else {
            validation.addError(new InvalidAlertPeriodicityActiveTimeWindowsType(alertPeriodicity.activeTimeWindows));
        }
    }
    else {
        validation.addError(new InvalidAlertPeriodicityInput(alertPeriodicity));
    }
    return validation.getOutput();
}
class InvalidAlertPeriodicityInput extends Error {
    constructor(periodicity) {
        super(`Alert periodicity is not valid input: ${JSON.stringify(periodicity)}`);
    }
}
exports.InvalidAlertPeriodicityInput = InvalidAlertPeriodicityInput;
class InvalidAlertPeriodicityInterval extends Error {
    constructor(interval) {
        super(`Periodicity interval: ${interval} is not valid value in interval min:
			${exports.periodicityIntervalValues.min}, max: ${exports.periodicityIntervalValues.max}`);
    }
}
exports.InvalidAlertPeriodicityInterval = InvalidAlertPeriodicityInterval;
class InvalidAlertPeriodicityActiveTimeWindowsType extends Error {
    constructor(activeTimeWindows) {
        super(`Periodicity active time windows is not an array: ${JSON.stringify(activeTimeWindows)}`);
    }
}
exports.InvalidAlertPeriodicityActiveTimeWindowsType = InvalidAlertPeriodicityActiveTimeWindowsType;
class UnknownAlertPeriodicityActiveTimeWindowType extends Error {
    constructor(type) {
        super(`Periodicity active time window item has unknown type: ${type}`);
    }
}
exports.UnknownAlertPeriodicityActiveTimeWindowType = UnknownAlertPeriodicityActiveTimeWindowType;
class InvalidSinceWeekdayInAlertPeriodicity extends Error {
    constructor(sinceWeekday) {
        super(`Periodicity active time window item has field sinceWeekday of incorrect type: ${sinceWeekday}`);
    }
}
exports.InvalidSinceWeekdayInAlertPeriodicity = InvalidSinceWeekdayInAlertPeriodicity;
class InvalidSinceTimeInAlertPeriodicity extends Error {
    constructor(sinceTime) {
        super(`Periodicity active time window item has field sinceTime of incorrect type or form: ${sinceTime}`);
    }
}
exports.InvalidSinceTimeInAlertPeriodicity = InvalidSinceTimeInAlertPeriodicity;
class InvalidUntilWeekdayInAlertPeriodicity extends Error {
    constructor(untilWeekday) {
        super(`Periodicity active time window item has field untilWeekday of incorrect type: ${untilWeekday}`);
    }
}
exports.InvalidUntilWeekdayInAlertPeriodicity = InvalidUntilWeekdayInAlertPeriodicity;
class InvalidUntilTimeInAlertPeriodicity extends Error {
    constructor(untilTime) {
        super(`Periodicity active time window item has field untilTime of incorrect type or form: ${untilTime}`);
    }
}
exports.InvalidUntilTimeInAlertPeriodicity = InvalidUntilTimeInAlertPeriodicity;
