import { ValidationOutput } from '../../Validation/Validation';
import { AlertPeriodicity } from '../AlertPeriodicity';
export declare const activeTimeWindowType: string[];
export declare const periodicityIntervalValues: {
    min: number;
    max: number;
};
export default function isAlertPeriodicityValid(periodicity: unknown): ValidationOutput<AlertPeriodicity>;
export declare class InvalidAlertPeriodicityInput extends Error {
    constructor(periodicity: unknown);
}
export declare class InvalidAlertPeriodicityInterval extends Error {
    constructor(interval: unknown);
}
export declare class InvalidAlertPeriodicityActiveTimeWindowsType extends Error {
    constructor(activeTimeWindows: unknown);
}
export declare class UnknownAlertPeriodicityActiveTimeWindowType extends Error {
    constructor(type: unknown);
}
export declare class InvalidSinceWeekdayInAlertPeriodicity extends Error {
    constructor(sinceWeekday: unknown);
}
export declare class InvalidSinceTimeInAlertPeriodicity extends Error {
    constructor(sinceTime: unknown);
}
export declare class InvalidUntilWeekdayInAlertPeriodicity extends Error {
    constructor(untilWeekday: unknown);
}
export declare class InvalidUntilTimeInAlertPeriodicity extends Error {
    constructor(untilTime: unknown);
}
