import type { Faker } from '.';
/**
 * Generates random values of different kinds. Some methods are deprecated and have been moved to dedicated modules.
 */
export declare class Random {
    private readonly faker;
    constructor(faker: Faker);
    /**
     * Returns a single random number between zero and the given max value or the given range with the specified precision.
     * The bounds are inclusive.
     *
     * @param options Maximum value or options object.
     * @param options.min Lower bound for generated number. Defaults to `0`.
     * @param options.max Upper bound for generated number. Defaults to `99999`.
     * @param options.precision Precision of the generated number. Defaults to `1`.
     *
     * @see faker.datatype.number()
     *
     * @example
     * faker.random.number() // 55422
     * faker.random.number(100) // 52
     * faker.random.number({ min: 1000000 }) // 431433
     * faker.random.number({ max: 100 }) // 42
     * faker.random.number({ precision: 0.01 }) // 64246.18
     * faker.random.number({ min: 10, max: 100, precision: 0.01 }) // 36.94
     *
     * @deprecated
     */
    number(options?: number | {
        min?: number;
        max?: number;
        precision?: number;
    }): number;
    /**
     * Returns a single random floating-point number for the given precision or range and precision.
     *
     * @param options Precision or options object.
     * @param options.min Lower bound for generated number. Defaults to `0`.
     * @param options.max Upper bound for generated number. Defaults to `99999`.
     * @param options.precision Precision of the generated number. Defaults to `0.01`.
     *
     * @see faker.datatype.float()
     *
     * @example
     * faker.random.float() // 51696.36
     * faker.random.float(0.1) // 52023.2
     * faker.random.float({ min: 1000000 }) // 212859.76
     * faker.random.float({ max: 100 }) // 28.11
     * faker.random.float({ precision: 0.1 }) // 84055.3
     * faker.random.float({ min: 10, max: 100, precision: 0.001 }) // 57.315
     *
     * @deprecated
     */
    float(options?: number | {
        min?: number;
        max?: number;
        precision?: number;
    }): number;
    /**
     * Returns random element from the given array.
     *
     * @template T The type of the entries to pick from.
     * @param array Array to pick the value from. Defaults to `['a', 'b', 'c']`.
     *
     * @example
     * faker.random.arrayElement() // 'b'
     * faker.random.arrayElement(['cat', 'dog', 'mouse']) // 'dog'
     *
     * @deprecated
     */
    arrayElement<T = string>(array?: ReadonlyArray<T>): T;
    /**
     * Returns a subset with random elements of the given array in random order.
     *
     * @template T The type of the entries to pick from.
     * @param array Array to pick the value from. Defaults to `['a', 'b', 'c']`.
     * @param count Number of elements to pick.
     *    When not provided, random number of elements will be picked.
     *    When value exceeds array boundaries, it will be limited to stay inside.
     *
     * @example
     * faker.random.arrayElements() // ['b', 'c']
     * faker.random.arrayElements(['cat', 'dog', 'mouse']) // ['mouse', 'cat']
     * faker.random.arrayElements([1, 2, 3, 4, 5], 2) // [4, 2]
     *
     * @deprecated
     */
    arrayElements<T>(array?: ReadonlyArray<T>, count?: number): T[];
    /**
     * Returns a random key from given object.
     *
     * @template T The type of `Record` to pick from.
     * @template K The keys of `T`.
     * @param object The object to get the keys from.
     * @param field If this is set to `'key'`, this method will a return a random key of the given instance.
     *
     * @see faker.helpers.objectKey()
     *
     * @example
     * const object = { keyA: 'valueA', keyB: 42 };
     * faker.random.objectElement(object, 'key') // 'keyB'
     *
     * @deprecated
     */
    objectElement<T extends Record<string, unknown>, K extends keyof T>(object: T, field: 'key'): K;
    /**
     * Returns a random value from given object.
     *
     * @template T The type of `Record` to pick from.
     * @template K The keys of `T`.
     * @param object The object to get the values from.
     * @param field If this is set to `'value'`, this method will a return a random value of the given instance.
     *
     * @see faker.helpers.objectValue()
     *
     * @example
     * const object = { keyA: 'valueA', keyB: 42 };
     * faker.random.objectElement(object) // 42
     * faker.random.objectElement(object, 'value') // 'valueA'
     *
     * @deprecated
     */
    objectElement<T extends Record<string, unknown>, K extends keyof T>(object: T, field?: unknown): T[K];
    /**
     * Returns a random key or value from given object.
     *
     * @template T The type of `Record` to pick from.
     * @template K The keys of `T`.
     * @param object The object to get the keys or values from.
     * @param field If this is set to `'key'`, this method will a return a random key of the given instance.
     * If this is set to `'value'`, this method will a return a random value of the given instance.
     * Defaults to `'value'`.
     *
     * @see faker.helpers.objectKey()
     * @see faker.helpers.objectValue()
     *
     * @example
     * const object = { keyA: 'valueA', keyB: 42 };
     * faker.random.objectElement(object) // 42
     * faker.random.objectElement(object, 'key') // 'keyB'
     * faker.random.objectElement(object, 'value') // 'valueA'
     *
     * @deprecated
     */
    objectElement<T extends Record<string, unknown>, K extends keyof T>(object?: T, field?: 'key' | 'value'): K | T[K];
    /**
     * Returns a UUID v4 ([Universally Unique Identifier](https://en.wikipedia.org/wiki/Universally_unique_identifier)).
     *
     * @see faker.datatype.uuid()
     *
     * @example
     * faker.random.uuid() // '4136cd0b-d90b-4af7-b485-5d1ded8db252'
     *
     * @deprecated
     */
    uuid(): string;
    /**
     * Returns the boolean value `true` or `false`.
     *
     * @see faker.datatype.boolean()
     *
     * @example
     * faker.random.boolean() // false
     *
     * @deprecated
     */
    boolean(): boolean;
    /**
     * Returns random word.
     *
     * @example
     * faker.random.word() // 'Seamless'
     */
    word(): string;
    /**
     * Returns string with set of random words.
     *
     * @param count Number of words. Defaults to a random value between `1` and `3`.
     *
     * @example
     * faker.random.words() // 'neural'
     * faker.random.words(5) // 'copy Handcrafted bus client-server Point'
     */
    words(count?: number): string;
    /**
     * Returns a random image url.
     *
     * @see faker.random.image()
     *
     * @example
     * faker.random.image() // 'http://placeimg.com/640/480/animals'
     *
     * @deprecated
     */
    image(): string;
    /**
     * Returns a random locale, that is available in this faker instance.
     * You can use the returned locale with `faker.setLocale(result)`.
     *
     * @example
     * faker.random.locale() // 'el'
     */
    locale(): string;
    /**
     * Generating a string consisting of lower/upper alpha characters based on count and upcase options.
     *
     * @param options Either the number of characters or an options instance. Defaults to `{ count: 1, upcase: false, bannedChars: [] }`.
     * @param options.count The number of characters to generate. Defaults to `1`.
     * @param options.upcase If true, the result will be uppercase. If false, it will be lowercase. Defaults to `false`.
     * @param options.bannedChars An array with characters to exclude. Defaults to `[]`.
     *
     * @example
     * faker.random.alpha() // 'b'
     * faker.random.alpha(10) // 'qccrabobaf'
     * faker.random.alpha({ count: 5, upcase: true, bannedChars: ['a'] }) // 'DTCIC'
     */
    alpha(options?: number | {
        count?: number;
        upcase?: boolean;
        bannedChars?: readonly string[];
    }): string;
    /**
     * Generating a string consisting of lower/upper alpha characters and digits based on count and upcase options.
     *
     * @param count The number of characters and digits to generate. Defaults to `1`.
     * @param options The options to use. Defaults to `{ bannedChars: [] }`.
     * @param options.bannedChars An array of characters and digits which should be banned in the generated string. Defaults to `[]`.
     *
     * @example
     * faker.random.alphaNumeric() // '2'
     * faker.random.alphaNumeric(5) // '3e5v7'
     * faker.random.alphaNumeric(5, { bannedChars: ["a"] }) // 'xszlm'
     */
    alphaNumeric(count?: number, options?: {
        bannedChars?: readonly string[];
    }): string;
    /**
     * Generates a given length string of digits.
     *
     * @param length The number of digits to generate. Defaults to `1`.
     * @param options The options to use. Defaults to `{}`.
     * @param options.allowLeadingZeros If true, leading zeros will be allowed. Defaults to `false`.
     * @param options.bannedDigits An array of digits which should be banned in the generated string. Defaults to `[]`.
     *
     * @example
     * faker.random.numeric() // '2'
     * faker.random.numeric(5) // '31507'
     * faker.random.numeric(42) // '56434563150765416546479875435481513188548'
     * faker.random.numeric(42, { allowLeadingZeros: true }) // '00564846278453876543517840713421451546115'
     * faker.random.numeric(6, { bannedDigits: ['0'] }) // '943228'
     */
    numeric(length?: number, options?: {
        allowLeadingZeros?: boolean;
        bannedDigits?: readonly string[];
    }): string;
    /**
     * Returns a hexadecimal number.
     *
     * @param count Length of the generated number. Defaults to `1`.
     *
     * @see faker.datatype.hexadecimal()
     *
     * @example
     * faker.random.hexaDecimal() // '0xb'
     * faker.random.hexaDecimal(10) // '0xaE13F044fb'
     *
     * @deprecated
     */
    hexaDecimal(count?: number): string;
}
