import { ICreatable, IEntity, IUpdatable } from '../../Lib/Model/model';
import { FeatureFlag } from '@signageos/common-types/dist/Feature/FeatureFlag';
import { EmailType } from '@signageos/common-types/dist/Email/EmailType';
import { Auth0Config } from '@signageos/common-types/dist/Auth0/Auth0';
import { IModelReadable } from '../../Lib/Model/IModelReadable';
import { IModelCreatable } from '../../Lib/Model/IModelCreatable';
import { IModelUpdatable } from '../../Lib/Model/IModelUpdatable';
import { IModelDeletable } from '../../Lib/Model/IModelDeletable';
export declare type WhiteLabelSettingsAuth0Config = Auth0Config & {
    connectionId: string;
};
export interface IWhiteLabelSettingsBase extends IEntity {
    customDomain?: string;
    emailFooter: string;
    notificationEmailAddress: string;
    notificationEmailName: string;
    pageTitle: string;
    uiThemeUid: string;
    disabledFeatures?: FeatureFlag[];
    disabledEmailTypes?: EmailType[];
    emailTemplateType?: string;
    termsAndConditionsUid?: string;
    privacyPolicyUrl?: string;
    auth0Config?: WhiteLabelSettingsAuth0Config;
}
export declare type IWhiteLabelSettings = IWhiteLabelSettingsBase & ICreatable & IUpdatable;
export interface IWhiteLabelSettingsModelRead extends IModelReadable<IWhiteLabelSettings> {
    fetchByCustomDomain(customDomain: Exclude<IWhiteLabelSettings['customDomain'], undefined>): Promise<IWhiteLabelSettings | null>;
}
export interface IWhiteLabelSettingsModelWrite extends IModelCreatable<IWhiteLabelSettings>, IModelUpdatable<IWhiteLabelSettingsBase>, IModelDeletable<IWhiteLabelSettings> {
}
export declare type WhiteLabelSettingsModel = IWhiteLabelSettingsModelRead & IWhiteLabelSettingsModelWrite;
//# sourceMappingURL=whiteLabelSettingsModel.d.ts.map