import { IModelCreatable } from '../../Lib/Model/IModelCreatable';
import { IModelDeletable } from '../../Lib/Model/IModelDeletable';
import { IModelReadable } from '../../Lib/Model/IModelReadable';
import { IModelUpdatable } from '../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../Lib/Model/model';
import { LayoutType } from '@signageos/common-types/dist/Layout/LayoutType';
export interface IUIThemeBase extends IEntity {
    logo: string;
    topBarBackgroundColor1: string;
    topBarBackgroundColor2: string;
    tabsCardActiveColor: string;
    tabsCardActiveBackground: string;
    btnPrimaryColor: string;
    btnPrimaryBackground: string;
    menuItemColor: string;
    menuItemHoverBackground: string;
    menuItemActiveBackground: string;
    hideMenuButtonColor: string;
    textColor: string;
    cardTitleColor: string;
    favicon?: string;
    logoSmall?: string;
    layout?: LayoutType;
}
export declare type IUITheme = IUIThemeBase & ICreatable & IUpdatable;
export interface IUIThemeModelRead extends IModelReadable<IUITheme> {
    fetchListByUids(uids: string[]): Promise<IUITheme[]>;
}
export interface IUIThemeModelWrite extends IModelCreatable<IUITheme>, IModelUpdatable<IUIThemeBase>, IModelDeletable<IUITheme> {
}
export declare type IUIThemeModel = IUIThemeModelRead & IUIThemeModelWrite;
//# sourceMappingURL=uiThemeModel.d.ts.map