import { IModelCreatable } from '../../Lib/Model/IModelCreatable';
import { IModelReadable } from '../../Lib/Model/IModelReadable';
import { IModelDeletable } from '../../Lib/Model/IModelDeletable';
import { OffsetPagination, Sorting } from '../../Lib/Pagination/paginationTypes';
import { IModelUpdatable } from '../../Lib/Model/IModelUpdatable';
export interface IThirdPartyCredentialsBase {
    uid: string;
    organizationUid: string;
    createdAt: Date;
    updatedAt: Date;
}
export interface IGoogleCredentials extends IThirdPartyCredentialsBase {
    type: 'google';
    customerId: string;
    clientEmail: string;
    privateKey: string;
}
export declare type IThirdPartyCredentials = IGoogleCredentials;
export declare type ThirdPartySortField = 'createdAt' | 'updatedAt';
export interface ThirdPartyCredentialsFilter {
    organizationUids?: string[];
    types?: IThirdPartyCredentials['type'][];
}
export interface ThirdPartyListArgs {
    filter: ThirdPartyCredentialsFilter;
    pagination?: OffsetPagination;
    sorting?: Sorting<ThirdPartySortField>;
}
export interface IThirdPartyCredentialsModel extends IModelCreatable<IThirdPartyCredentials>, IModelUpdatable<IThirdPartyCredentials>, IModelReadable<IThirdPartyCredentials>, IModelDeletable<IThirdPartyCredentials> {
    fetchListByFilter(args: ThirdPartyListArgs): Promise<IThirdPartyCredentials[]>;
}
//# sourceMappingURL=thirdPartyCredentialsModel.d.ts.map