import { IModelCreatable } from '../../Lib/Model/IModelCreatable';
import { IModelDeletable } from '../../Lib/Model/IModelDeletable';
import { IModelReadable } from '../../Lib/Model/IModelReadable';
import { IModelUpdatable } from '../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../Lib/Model/model';
/**
 * termsAndConditionsUid is unique identifier of the entity together with version
 */
export interface ITermsAndConditionsVersionBase extends IEntity {
    termsAndConditionsUid: string;
    url: string;
    version: string;
}
export declare type ITermsAndConditionsVersion = ITermsAndConditionsVersionBase & ICreatable & IUpdatable;
export interface IFetchLatestByTermsAndConditionsUidParams {
    termsAndConditionsUid: ITermsAndConditionsVersion['termsAndConditionsUid'];
}
export interface ITermsAndConditionsVersionModelRead extends IModelReadable<ITermsAndConditionsVersion> {
    fetchLatestByTermsAndConditionsUid({ termsAndConditionsUid, }: IFetchLatestByTermsAndConditionsUidParams): Promise<ITermsAndConditionsVersion | null>;
}
export interface ITermsAndConditionsVersionModelWrite extends IModelCreatable<ITermsAndConditionsVersion>, IModelUpdatable<ITermsAndConditionsVersion>, IModelDeletable<ITermsAndConditionsVersion> {
}
export declare type TermsAndConditionsVersionModel = ITermsAndConditionsVersionModelRead & ITermsAndConditionsVersionModelWrite;
//# sourceMappingURL=termsAndConditionsVersionModel.d.ts.map