import { OffsetPagination, Sorting } from '../../Lib/Pagination/paginationTypes';
import { IDevice } from '../Device/deviceModel';
export declare type SystemLogSortField = 'receivedAt' | 'recordedAt';
export interface ISystemLogPropertyFilter {
    type?: string;
    excludeType?: string;
    receivedSince?: Date;
    receivedUntil?: Date;
    recordedSince?: Date;
    recordedUntil?: Date;
}
export interface ISystemLogPayload {
    type: string;
}
export interface ISystemLog {
    id: string;
    payload: ISystemLogPayload;
    deviceIdentityHash: string;
    /** Server time when the log was received */
    receivedAt: Date;
    /** Device time when the log was recorded */
    recordedAt: Date;
}
export interface IUniqueTypeParams {
    device: IDevice;
    receivedSince?: Date;
    receivedUntil?: Date;
    recordedSince?: Date;
    recordedUntil?: Date;
}
export interface ISystemLogModel {
    fetchById(id: string): Promise<ISystemLog | null>;
    create(systemLog: ISystemLog): Promise<void>;
    fetchListByDeviceAndPropertyFilter(device: IDevice, propertyFilter: ISystemLogPropertyFilter, pagination?: OffsetPagination, customSorting?: Sorting<SystemLogSortField>): Promise<ISystemLog[]>;
    fetchUniqueTypesByDevice(params: IUniqueTypeParams): Promise<ISystemLogPayload['type'][]>;
    countByDeviceAndPropertyFilter(device: IDevice, propertyFilter: ISystemLogPropertyFilter): Promise<number>;
}
//# sourceMappingURL=systemLogModel.d.ts.map