export interface IServerInstance {
    uid: string;
    createdAt: Date;
    host: string | null;
    aliveAt?: Date;
}
export interface IServerInstanceModel<TServerInstance extends IServerInstance> {
    fetchByUid(uid: string): Promise<TServerInstance | null>;
    fetchList(): Promise<TServerInstance[]>;
    create(uid: string, createdAt: Date): Promise<void>;
    updateHost(serverInstanceRow: IServerInstance, host: string): Promise<void>;
    markAlive?(serverInstanceRow: IServerInstance, aliveAt: Date): Promise<void>;
    delete(serverInstanceRow: IServerInstance, removedAt: Date): Promise<void>;
}
//# sourceMappingURL=serverInstanceModel.d.ts.map