import { IOrganizationIdentification } from '../Organization/organizationModel';
import { IDevice } from '../Device/deviceModel';
import IPolicyItem from '@signageos/common-types/dist/Policy/IPolicyItem';
/** @deprecated Use {@link IPolicyItem} instead */
export declare type PolicyBase = IPolicyItem;
export interface IPolicy {
    uid: string;
    name: string;
    organizationUid: string;
    items: IPolicyItem[];
}
export declare type IPolicyIdentification = Pick<IPolicy, 'uid'>;
export interface IPolicyWithPriority {
    uid: string;
    priority: number;
    assignedAt: Date;
}
export declare type PolicyItemAssignable = IPolicyItem & Partial<{
    policyUid: string;
    updatedAt: Date;
    assignedAt: Date;
}>;
export declare type IPolicyModel = IPolicyModelRead & IPolicyModelWrite;
export interface IPolicyModelRead {
    fetchByUid(uid: string): Promise<IPolicy | null>;
    fetchListByOrganization(organization: IOrganizationIdentification): Promise<IPolicy[]>;
    fetchListByDeviceSortedByPriority(device: IDevice): Promise<IPolicy[]>;
    fetchMergedByDevice(device: IDevice): Promise<PolicyItemAssignable[]>;
}
export interface IPolicyModelWrite {
    create(uid: string, name: string, organization: IOrganizationIdentification, items: IPolicyItem[]): Promise<void>;
    updateName(policyRow: IPolicyIdentification, name: string): Promise<void>;
    updateItems(policyRow: IPolicyIdentification, items: IPolicyItem[]): Promise<void>;
    remove(policyRow: IPolicyIdentification): Promise<void>;
}
//# sourceMappingURL=policyModel.d.ts.map