export interface IPackageVersionNote {
    uid: string;
    packageVersionUid: string;
    noteText: string;
    createdAt: Date;
    createdByAccountId?: number;
    deletedAt?: Date;
}
export interface IPackageVersionNoteModel {
    fetchByUid(uid: string): Promise<IPackageVersionNote | null>;
    fetchListByPackageVersionUid(packageVersionUid: string): Promise<IPackageVersionNote[]>;
    create(uid: string, packageVersionUid: string, noteText: string, createdAt: Date, createdByAccountId: number | undefined): Promise<void>;
    delete(packageVersionNote: IPackageVersionNote, deletedAt: Date): Promise<void>;
}
//# sourceMappingURL=packageVersionNoteModel.d.ts.map