import { IDistributionByDevicePlan } from './organizationModel';
export declare enum OrganizationStatisticScope {
    Day = "day",
    Month = "month",
    Year = "year"
}
export interface IOrganizationStatisticsSnapshot {
    organizationUid: string;
    scope: OrganizationStatisticScope;
    year: number;
    month?: number;
    day?: number;
}
export interface IOrganizationDeviceStatisticsSnapshot extends IOrganizationStatisticsSnapshot {
    devices: {
        total: IDistributionByDevicePlan;
        new: IDistributionByDevicePlan;
        deprovisioned?: number;
    };
}
export declare type IOrganizationStatisticsModel = IOrganizationStatisticsModelRequired;
export interface CreateDeviceSnapshotProps {
    organizationUid: string;
    scope: OrganizationStatisticScope;
    totalDevices: IDistributionByDevicePlan;
    newDevices: IDistributionByDevicePlan;
    deprovisionedDevices?: number;
    year: number;
    month?: number;
    day?: number;
}
export interface IOrganizationStatisticsModelRequired {
    createDeviceSnapshot(props: CreateDeviceSnapshotProps): Promise<void>;
    getOrganizationDeviceStatisticsSnapshot(organizationUid: string, scope: OrganizationStatisticScope, year: number, month?: number, day?: number): Promise<IOrganizationDeviceStatisticsSnapshot | null>;
    getOrganizationDeviceStatisticsSnapshots(organizationUid: string, scope: OrganizationStatisticScope, since: Date, until: Date): Promise<IOrganizationDeviceStatisticsSnapshot[]>;
    getOrganizationsDeviceStatisticsSnapshots(organizationUids: string[], scope: OrganizationStatisticScope, since: Date, until: Date): Promise<{
        [organizationUid: string]: IOrganizationDeviceStatisticsSnapshot[];
    }>;
}
//# sourceMappingURL=organizationStatisticsModel.d.ts.map