import { IModelCreatable } from '../../../Lib/Model/IModelCreatable';
import { IModelDeletable } from '../../../Lib/Model/IModelDeletable';
import { IModelReadable } from '../../../Lib/Model/IModelReadable';
import { IModelUpdatable } from '../../../Lib/Model/IModelUpdatable';
import { OffsetPagination, Sorting } from '../../../Lib/Pagination/paginationTypes';
import { IPaginator } from '../../../MongoDB/paginatorHelper';
import { IOrganization } from '../organizationModel';
export interface IOrganizationTag {
    uid: string;
    organizationUid: string;
    name: string;
    createdAt: Date;
    updatedAt: Date;
    color?: string;
    parentTagUid?: string;
    children?: IOrganizationTagChild[];
}
/** Contains list of all tag uids that are part of the same family tree */
export declare type OrganizationTagFamilyTreeUids = string[];
export interface IOrganizationTagChild extends IOrganizationTag {
    depth: number;
}
export interface OrganizationTagWithCounts extends IOrganizationTag {
    devicesCount: number;
    locationsCount: number;
}
export interface IOrganizationTagCreate {
    organizationUid: string;
    name: string;
    color?: string;
    parentTagUid?: string;
}
export interface IOrganizationTagUpdate {
    name: string;
    color?: string;
    parentTagUid?: string;
}
export declare type IOrganizationTagModel<TOrganizationTag extends IOrganizationTag> = IOrganizationTagModelRequired<TOrganizationTag>;
export declare type OrganizationTagSortKeys = keyof Pick<IOrganizationTag, 'createdAt'>;
export declare type IOrganizationTagIdentification = {
    uid: IOrganizationTag['uid'];
};
export declare type TSortField = 'name' | 'createdAt';
export interface PropertyFilter {
    search?: string;
    uids?: IOrganizationTag['uid'][];
    organizationUids?: IOrganization['uid'][];
    color?: IOrganizationTag['color'];
    assignedTo?: TagAssignedTo[];
    /** If children are included the whole property filter applies to them as well. */
    includeChildren?: boolean;
    rootTag?: boolean;
}
export interface FetchListProps {
    filter?: PropertyFilter;
    pagination?: OffsetPagination;
    sort?: Sorting<TSortField>;
}
/** Enum used only for filtering */
export declare enum TagAssignedTo {
    DEVICE = "DEVICE",
    LOCATION = "LOCATION",
    NOT_ASSIGNED = "NOT_ASSIGNED"
}
export interface IOrganizationTagModelRequired<TOrganizationTag extends IOrganizationTag> extends IModelDeletable<IOrganizationTagIdentification>, IModelReadable<TOrganizationTag>, IModelUpdatable<TOrganizationTag>, IModelCreatable<TOrganizationTag> {
    fetchListByPropertyFilter(props: FetchListProps): Promise<OrganizationTagWithCounts[]>;
    countByPropertyFilter(filter: PropertyFilter): Promise<number>;
    fetchListByOrganizationUid(organizationUid: string): Promise<TOrganizationTag[] | null>;
    fetchListByOrganizationUids(organizationUids: string[]): Promise<TOrganizationTag[]>;
    fetchCountByOrganizationUids(organizationUids: string[]): Promise<number>;
    /**
     *
     * @deprecated Use `fetchListByUids` instead
     */
    fetchListByUidList(uidList: string[]): Promise<TOrganizationTag[] | null>;
    fetchByNameAndOrganizationUid(organizationUid: string, name: string): Promise<TOrganizationTag | null>;
    fetchListByOrganizationUidAndPropertyFilter(organizationUid: string, pagination: IPaginator<OrganizationTagSortKeys>): Promise<TOrganizationTag[]>;
    fetchUniqueColors(filter: PropertyFilter): Promise<string[]>;
    /** Returns uid of tag and uids of all tag children (into depth) */
    fetchOrganizationTagChildrenTreeUids(tagUid: string): Promise<OrganizationTagFamilyTreeUids>;
}
//# sourceMappingURL=organizationTagModel.d.ts.map