import { IOrganization, IOrganizationIdentification } from '../Organization/organizationModel';
export interface IIssuedServerLicense {
    id: any;
    licenseKey: string;
    licenseSecret: string | null;
    organizationUid: string;
    createdAt: Date;
}
export interface IIssuedServerLicenseModel {
    fetchByLicenseKey(licenseKey: string): Promise<IIssuedServerLicense | null>;
    setLicenseSecret(issuedServerLicenseRow: IIssuedServerLicense, licenseSecret: string): Promise<void>;
    fetchListByOrganizationUid(organizationUid: string): Promise<IIssuedServerLicense[]>;
    fetchByOrganizationAndLicenseKey(organization: IOrganizationIdentification, licenseKey: string): Promise<IIssuedServerLicense | null>;
    create(licenseKey: string, organization: IOrganization, createdAt: Date): Promise<void>;
}
//# sourceMappingURL=issuedServerLicenseModel.d.ts.map