export interface IFrontAppletVersion {
    version: string;
    createdAt: Date;
    releasedAt?: Date | null;
}
export interface IFrontAppletVersionModel<TFrontAppletVersion extends IFrontAppletVersion> {
    fetchByVersion(version: string): Promise<TFrontAppletVersion | null>;
    fetchAll(onlyReleased?: boolean): Promise<TFrontAppletVersion[]>;
    create(version: string, createdAt: Date): Promise<void>;
    release(version: string, releasedAt?: Date): Promise<void>;
}
//# sourceMappingURL=frontAppletVersionModel.d.ts.map