/// <reference types="lib.es2017.observable" />
export interface IDomain {
    name: string;
    lastEventReceivedAt: Date;
    lastEventSecondaryIndex: number;
}
export interface IEvent {
    receivedAt: Date;
    secondaryIndex: number;
}
export interface IDomainModel {
    fetchByName(name: string): Promise<IDomain | null>;
    create(name: string, event: IEvent): Promise<void>;
    update(name: string, event: IEvent): Promise<void>;
    observeByName(name: string): Promise<Observable<IDomain, Error>>;
}
//# sourceMappingURL=domainModel.d.ts.map