import { IDevice, IDeviceIdentification } from '../deviceModel';
import { IAccount } from '../../Account/accountModel';
export interface IDeviceVerification {
    id: any;
    createdAt: Date;
    deviceIdentityHash: string;
    hash: string;
    verifiedAt: Date | null;
    verifierId: number | null;
}
export declare type IDeviceVerificationModel = IDeviceVerificationModelRequired | (IDeviceVerificationModelRequired & IDeviceVerificationModelOptional);
export interface IDeviceVerificationModelRequired {
    fetchByDeviceAndHash(device: IDevice, hash: string): Promise<IDeviceVerification | null>;
    fetchByHash(hash: string): Promise<IDeviceVerification | null>;
    fetchByDevice(device: IDeviceIdentification): Promise<IDeviceVerification | null>;
    create(uid: string, device: IDevice, hash: string, createdAt: Date): Promise<void>;
    verify(deviceVerificationRow: IDeviceVerification, verifier: IAccount | null, verifiedAt: Date): Promise<void>;
    invalidate(deviceVerificationRow: IDeviceVerification): Promise<void>;
}
export interface IDeviceVerificationModelOptional {
    fetchUnverifiedByHash(hash: string): Promise<IDeviceVerification | null>;
    fetchById(id: string): Promise<IDeviceVerification | null>;
}
//# sourceMappingURL=deviceVerificationModel.d.ts.map