/// <reference types="lib.es2017.observable" />
import { IDevice } from '../deviceModel';
import IChanges from '../../../IChanges';
export interface IDeviceTemperature {
    uid: string;
    deviceIdentityHash: string;
    temperature: number;
    createdAt: Date;
}
export interface IDeviceTemperaturePropertyFilter {
    deviceIdentityHash?: string;
    createdSince?: Date;
    createdUntil?: Date;
}
export interface IDeviceTemperatureModel extends IDeviceTemperatureModelWrite {
    fetchByUid(uid: string): Promise<IDeviceTemperature | null>;
    fetchListByPropertyFilter(propertyFilter: IDeviceTemperaturePropertyFilter, limit?: number): Promise<IDeviceTemperature[]>;
    fetchListByDevice(device: IDevice): Promise<IDeviceTemperature[]>;
    fetchLatestByDevice(device: IDevice): Promise<IDeviceTemperature | null>;
}
export interface IDeviceTemperatureModelWrite {
    create(device: IDevice, temperature: number, createdAt: Date): Promise<void>;
    deleteCreatedUntil(createdUntil: Date): Promise<void>;
}
export interface IDeviceTemperatureModelObservable {
    observeLatestByDevice(device: IDevice): Promise<Observable<IChanges<IDeviceTemperature>, Error>>;
}
//# sourceMappingURL=deviceTemperatureModel.d.ts.map