export interface IDeviceSession {
    deviceIdentityHash: string;
    sessionUid: string;
    createdAt: Date;
}
export interface IDeviceSessionModelRead {
    fetchByUid(sessionUid: IDeviceSession['sessionUid']): Promise<IDeviceSession | null>;
    fetchByDeviceIdentityHash(deviceIdentityHash: string): Promise<IDeviceSession | null>;
}
export interface IDeviceSessionModelWrite {
    create({ sessionUid, deviceIdentityHash, createdAt, }: {
        sessionUid: IDeviceSession['sessionUid'];
        deviceIdentityHash: string;
        createdAt: IDeviceSession['createdAt'];
    }): Promise<void>;
    remove(session: IDeviceSession): Promise<void>;
}
export declare type IDeviceSessionModel = IDeviceSessionModelRead & IDeviceSessionModelWrite;
//# sourceMappingURL=deviceSessionModel.d.ts.map