/// <reference types="lib.es2017.observable" />
import { IDevice } from '../deviceModel';
import IChanges from '../../../IChanges';
import { OffsetPagination } from '../../../Lib/Pagination/paginationTypes';
export interface IDeviceScreenshotPropertyFilter {
    deviceIdentityHash?: string;
    takenSince?: Date;
    takenUntil?: Date;
}
export interface IDeviceScreenshot {
    id: string;
    deviceIdentityHash: string;
    takenAt: Date;
    uri: string;
}
export declare type IDeviceScreenshotModel = IDeviceScreenshotModelRead & IDeviceScreenshotModelWrite & IDeviceScreenshotModelObservable;
export interface IDeviceScreenshotModelRead {
    fetchListByPropertyFilter(propertyFilter: IDeviceScreenshotPropertyFilter, pagination?: OffsetPagination, descending?: boolean): Promise<IDeviceScreenshot[]>;
    countByPropertyFilter(propertyFilter: IDeviceScreenshotPropertyFilter): Promise<number>;
    fetchLatestByDevice(deviceRow: IDevice): Promise<IDeviceScreenshot | null>;
    fetchLatestByDeviceIdentityHashes(deviceIdentityHashes: IDevice['identityHash'][]): Promise<IDeviceScreenshot[]>;
    fetchScreenshotHistoryByDeviceAndLimit(deviceRow: IDevice, limit: number): Promise<IDeviceScreenshot[]>;
}
export interface IDeviceScreenshotModelWrite {
    create(deviceIdentityHash: string, uri: string, takenAt: Date): Promise<void>;
    deleteTakenUntil(takenUntil: Date): Promise<void>;
}
export interface IDeviceScreenshotModelObservable {
    observeLatestByDevice(deviceRow: IDevice): Promise<Observable<IChanges<IDeviceScreenshot>, Error>>;
}
//# sourceMappingURL=deviceScreenshotModel.d.ts.map