import { IDevice } from '../deviceModel';
export interface IDeviceRmServerPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceRmServer {
    uid: string;
    deviceIdentityHash: string;
    rmServerUrl: string;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceRmServerModel {
    fetchByUid(uid: string): Promise<IDeviceRmServer | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceRmServer | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceRmServer | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceRmServer[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceRmServer[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceRmServerPropertyFilter): Promise<IDeviceRmServer[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, RmServer: number, createdAt: Date): Promise<void>;
    markSucceeded(deviceRmServerRow: IDeviceRmServer, succeededAt: Date): Promise<void>;
    markFailed(deviceRmServerRow: IDeviceRmServer, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=DeviceRmServerModel.d.ts.map