import { IDevice } from '../deviceModel';
export interface IDeviceReportPropertyFilter {
    deviceIdentityHash?: string;
    createdSince?: Date;
    createdUntil?: Date;
}
export interface IDeviceReportFile {
    uid: string;
    createdAt: Date;
    deviceIdentityHash: string;
    urn: string;
}
export interface IDeviceReportFileModel {
    fetchListByPropertyFilter(propertyFilter: IDeviceReportPropertyFilter, limit?: number): Promise<IDeviceReportFile[]>;
    fetchByUid(uid: string): Promise<IDeviceReportFile | null>;
    fetchListByDevice(deviceRow: IDevice): Promise<IDeviceReportFile[]>;
    create(deviceRow: IDevice, urn: string, createdAt: Date): Promise<void>;
    deleteCreatedUntil(createdUntil: Date): Promise<void>;
}
//# sourceMappingURL=deviceReportFileModel.d.ts.map