import { IDevice } from '../deviceModel';
export interface IDeviceRemoteControlPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceRemoteControl {
    uid: string;
    deviceIdentityHash: string;
    enabled: boolean;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceRemoteControlModel {
    fetchByUid(uid: string): Promise<IDeviceRemoteControl | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceRemoteControl | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceRemoteControl | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceRemoteControl[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceRemoteControl[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceRemoteControlPropertyFilter): Promise<IDeviceRemoteControl[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, enabled: boolean, createdAt: Date): Promise<void>;
    markSucceeded(deviceRemoteControlRow: IDeviceRemoteControl, succeededAt: Date): Promise<void>;
    markFailed(deviceRemoteControlRow: IDeviceRemoteControl, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceRemoteControlModel.d.ts.map