"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSortingHelper = void 0;
const paginationTypes_1 = require("../../../Lib/Pagination/paginationTypes");
const pagination_1 = require("../../../Lib/Pagination/pagination");
function getSortingHelper(sorting) {
    return (0, pagination_1.getSorting)({
        defaultSorting: {
            field: 'createdAt',
            order: paginationTypes_1.SortOrder.DESC,
        },
        sorting: sorting
            ? {
                field: sorting.field,
                order: sorting.order,
            }
            : undefined,
    });
}
exports.getSortingHelper = getSortingHelper;
//# sourceMappingURL=deviceProvisioningRecipe.utils.js.map