import { IDevice } from '../deviceModel';
export interface IDeviceScheduledPowerAction {
    uid: string;
    createdAt: Date;
    deviceIdentityHash: string;
    powerType: string;
    weekdays: string[];
    time: string;
}
export interface IDeviceScheduledPowerActionModel {
    fetchByUid(uid: string): Promise<IDeviceScheduledPowerAction | null>;
    fetchListByDevice(device: IDevice): Promise<IDeviceScheduledPowerAction[]>;
    fetchListByDevices(devices: IDevice[]): Promise<IDeviceScheduledPowerAction[]>;
    create(uid: string, createdAt: Date, device: IDevice, powerType: string, weekdays: string[], time: string): Promise<void>;
    remove(deviceScheduledPowerActionRow: IDeviceScheduledPowerAction): Promise<void>;
}
//# sourceMappingURL=deviceScheduledPowerActionModel.d.ts.map