import { IDeviceArtificialIdentification } from '../deviceModel';
import PowerActionType from '@signageos/common-types/dist/Device/Power/PowerActionType';
export interface IDevicePowerAction {
    uid: string;
    createdAt: Date;
    deviceIdentityHash: string;
    powerType: PowerActionType;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDevicePowerActionModel {
    fetchByUid(uid: string): Promise<IDevicePowerAction | null>;
    create(uid: string, deviceIdentityHash: string, powerType: PowerActionType, createdAt: Date): Promise<void>;
    markSucceed(devicePowerActionRow: IDevicePowerAction, succeededAt: Date): Promise<void>;
    markFailed(devicePowerActionRow: IDevicePowerAction, failedAt: Date): Promise<void>;
    fetchListByDevice(device: IDeviceArtificialIdentification): Promise<IDevicePowerAction[]>;
    fetchLatestListByDevices(devices: IDeviceArtificialIdentification[], limit: number): Promise<IDevicePowerAction[]>;
    fetchListByDevices(devices: IDeviceArtificialIdentification[]): Promise<IDevicePowerAction[]>;
    /**
     * It returns all items that are not marked as succeededAt or failedAt
     */
    fetchUnfinishedListByDeviceAndType(device: IDeviceArtificialIdentification, powerType: PowerActionType): Promise<IDevicePowerAction[]>;
}
//# sourceMappingURL=devicePowerActionModel.d.ts.map