export interface IDeviceNote {
    uid: string;
    deviceIdentityHash: string;
    accountId: number;
    note: string;
    createdAt: Date;
    archivedAt?: Date | null;
}
export declare type IDeviceNoteModel<TDeviceNote extends IDeviceNote> = IDeviceNoteModelRequired<TDeviceNote>;
export interface IDeviceNoteModelRequired<TDeviceNote extends IDeviceNote> {
    create(uid: string, deviceIdentityHash: string, accountId: number, note: string, createdAt: Date): Promise<void>;
    fetchByUid(uid: string): Promise<TDeviceNote | null>;
    fetchListByDeviceIdentityHash(deviceIdentityHash: string): Promise<TDeviceNote[]>;
    fetchListByDeviceIdentityHashes(deviceIdentityHashes: string[]): Promise<TDeviceNote[]>;
    archive(deviceNoteRow: IDeviceNote, archivedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceNoteModel.d.ts.map