/// <reference types="lib.es2017.observable" />
import { ISort } from '../../../Lib/Sort/sort';
import { TPagination } from '../../../Lib/Pagination/paginationTypes';
import { IDevice, IDeviceMinimal } from '../deviceModel';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';
/** @deprecated Use DeviceTelemetryType from @signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType instead */
export declare type DeviceMonitoringType = DeviceTelemetryType;
/** @deprecated Use DeviceTelemetryType from @signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType instead */
export declare const DeviceMonitoringType: typeof DeviceTelemetryType;
/** @deprecated Use MonitoringLogData from @signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData instead */
export declare type LogData = MonitoringLogData;
export interface IDeviceMonitoringLog<T extends DeviceTelemetryType> {
    id: string;
    deviceIdentityHash: string;
    organizationUid?: string;
    type: T;
    createdAt: Date;
    data: MonitoringLogData[T];
}
export declare type IDeviceMonitoringLogLike<T extends DeviceTelemetryType> = {
    id: string;
    deviceIdentityHash: string;
    organizationUid?: string;
    type: T;
    createdAt: Date;
} & MonitoringLogData[T];
export interface IDeviceMonitoringLogFilter {
    since?: Date;
    until?: Date;
    limit?: number;
}
export interface IFetchLatestListByDevicesFilter {
    identityHashes?: IDevice['identityHash'][];
    since?: Date;
    until?: Date;
}
export declare type TFetchLatestListByDevicesSorters = 'createdAt';
export interface IFetchLatestListByDevicesParams<SortFiled> {
    devices: IDeviceMinimal[];
    filter?: IFetchLatestListByDevicesFilter;
    sort?: ISort<SortFiled>;
    pagination?: TPagination;
}
export declare type IDeviceMonitoringLogModel = IDeviceMonitoringLogModelLatest & IDeviceMonitoringLogModelStats & IDeviceMonitoringLogModelWrite & IDeviceMonitoringLogModelObservable;
export interface IDeviceMonitoringLogModelLatest {
    fetchLatestByDeviceAndType<T extends DeviceTelemetryType>(device: IDeviceMinimal, type: T): Promise<IDeviceMonitoringLog<T> | null>;
    fetchLatestByIdentityHashAndType<T extends DeviceTelemetryType>(identityHash: IDeviceMinimal['identityHash'], type: T): Promise<IDeviceMonitoringLog<T> | null>;
    fetchLatestByDevicesAndType<T extends DeviceTelemetryType>(deviceIdentityHashes: IDevice['identityHash'][], type: T): Promise<IDeviceMonitoringLog<T>[]>;
    fetchLatestListByDevices<T extends DeviceTelemetryType>({ devices, filter, sort, pagination, }: IFetchLatestListByDevicesParams<TFetchLatestListByDevicesSorters>): Promise<IDeviceMonitoringLog<T>[]>;
}
export interface IDeviceMonitoringLogPropertyFilter {
    deviceIdentityHash: IDevice['identityHash'];
    type: DeviceTelemetryType;
    since?: Date;
    until?: Date;
}
export interface IFetchDeviceMonitoringLogParams {
    filter: IDeviceMonitoringLogPropertyFilter;
    sort?: ISort<'createdAt'>;
    pagination?: TPagination;
}
export interface IDeviceMonitoringLogModelStats {
    fetchById(id: string): Promise<IDeviceMonitoringLog<DeviceTelemetryType> | null>;
    fetchListByDevice<T extends DeviceTelemetryType>(device: IDevice, type: T, filter?: IDeviceMonitoringLogFilter): Promise<IDeviceMonitoringLog<T>[]>;
    /** @deprecated use fetchList instead */
    fetchListByDeviceAndTypeSince<T extends DeviceTelemetryType>(device: IDevice, type: T, since: Date): Promise<IDeviceMonitoringLog<T>[]>;
    /** @deprecated use fetchList instead */
    fetchMonitoringLogListByDevice<T extends DeviceTelemetryType>(device: IDevice, type: T, since: Date, until: Date, limit?: number): Promise<IDeviceMonitoringLog<T>[]>;
    /** @deprecated use fetchList instead */
    fetchLastNValuesByDeviceAndType<T extends DeviceTelemetryType>(device: IDevice, type: T, n: number): Promise<IDeviceMonitoringLog<T>[]>;
    fetchUptimeByOrganization(organizationUid: string, start: Date, stop: Date): Promise<{
        uptime: number;
        downtime: number;
    } | undefined>;
    fetchUptimeByIdentityHash(identityHash: string, start: Date, stop: Date): Promise<{
        uptime: number;
        downtime: number;
    } | undefined>;
    fetchDevicesStatusCount(start: Date, stop: Date, organizationUids: string[]): Promise<{
        offlineCount: number;
        onlineCount: number;
        count: number;
    } | undefined>;
    fetchOfflineDeviceIdentityHashes(start: Date, stop: Date, organizationUids: string[], 
    /** time in seconds device has to be offline */
    offlineForMoreThan?: number): Promise<Array<{
        deviceIdentityHash: string;
    }>>;
    fetchLatelyWentOnlineDeviceIdentityHashes(start: Date, stop: Date, organizationUids: string[], 
    /** time in seconds it must have been offline before it went online */
    beforeOfflineAtLeast: number): Promise<Array<{
        deviceIdentityHash: string;
    }>>;
    fetchList<T extends DeviceTelemetryType>(params?: IFetchDeviceMonitoringLogParams): Promise<IDeviceMonitoringLog<T>[]>;
}
export interface IDeviceMonitoringLogModelWrite {
    create<T extends DeviceTelemetryType>(id: string, type: T, device: IDevice, createdAt: Date, data: MonitoringLogData[T]): Promise<void>;
    createMany(monitoringLogs: IDeviceMonitoringLog<DeviceTelemetryType>[]): Promise<void>;
    invalidate<T extends DeviceTelemetryType>(type: T, device: IDevice): Promise<void>;
}
export interface IDeviceMonitoringLogModelObservable {
    observeByDeviceAndTypeWithInitialData<T extends DeviceTelemetryType>(device: IDevice, type: T): Promise<Observable<IDeviceMonitoringLog<T>, Error>>;
}
export declare type IDeviceMonitoringLogModelFull = IDeviceMonitoringLogModelLatest & IDeviceMonitoringLogModelStats & IDeviceMonitoringLogModelWrite;
//# sourceMappingURL=deviceMonitoringLogModel.d.ts.map