/**
 * Binary representation of data type.
 * It respect binary operations for comparison to allow combine more types together.
 * For example `DataType.BOOLEAN | DataType.NULL` is a valid type.
 */
export declare enum DataType {
    NULL = 1,
    TIMESTAMP = 2,
    INT = 4,
    STRING = 8,
    JSON = 16,
    BOOLEAN = 32,
    FLOAT = 64,
    MISSING = 128
}
/**
 * It returns true when the given value data type is at least a superset of compareTo data type.
 * Example:
 * isOfDataType(DataType.INT | DataType.FLOAT, DataType.INT) // true
 * isOfDataType(DataType.STRING | DataType.FLOAT, DataType.INT) // false
 */
export declare function isOfDataType(value: DataType, compareTo: DataType): boolean;
//# sourceMappingURL=dataType.d.ts.map