/// <reference types="lib.es2017.observable" />
import { IDevice } from '../deviceModel';
import IChanges from '../../../IChanges';
export interface IDeviceHourlyConnectedStatus {
    uid: string;
    createdAt: Date;
    deviceIdentityHash: string;
    from: Date;
    to: Date;
    time: number;
}
export declare type IDeviceHourlyConnectedStatusModel = IDeviceHourlyConnectedStatusModelRead & IDeviceHourlyConnectedStatusModelWrite & IDeviceHourlyConnectedStatusModelObservable;
export interface IDeviceHourlyConnectedStatusModelRead {
    fetchListByDevice(device: IDevice): Promise<IDeviceHourlyConnectedStatus[]>;
    fetchListByDeviceAndFromTo(device: IDevice, from: Date, to: Date): Promise<IDeviceHourlyConnectedStatus[]>;
}
export interface IDeviceHourlyConnectedStatusModelWrite {
    create(device: IDevice, createdAt: Date, from: Date, to: Date, time: number): Promise<void>;
    deleteFromBefore(fromBefore: Date): Promise<void>;
}
export interface IDeviceHourlyConnectedStatusModelObservable {
    observeLatestConnectedStatusByDevice(device: IDevice, after: Date): Promise<Observable<IChanges<IDeviceHourlyConnectedStatus>, Error>>;
}
//# sourceMappingURL=deviceHourlyConnectedStatusModel.d.ts.map