/// <reference types="lib.es2017.observable" />
export interface IDeviceExportLog {
    accountId: number;
    requestId: string;
    startedAt: Date;
    finishedAt?: Date;
    downloadLink?: string;
    errorMessage?: string;
}
export interface IDeviceExportLogWriteModel {
    create(accountId: number, requestId: string, startedAt: Date): Promise<void>;
    markSucceeded(requestId: string, finishedAt: Date, downloadLink: string): Promise<void>;
    markFailed(requestid: string, finishedAt: Date, errorMessage?: string): Promise<void>;
}
export interface IDeviceExportLogReadModel {
    fetchListByAccountId(accountId: number): Promise<IDeviceExportLog[]>;
    fetchByRequestId(requestId: string): Promise<IDeviceExportLog | null>;
}
export interface IDeviceExportLogModel extends IDeviceExportLogReadModel, IDeviceExportLogWriteModel {
}
export interface IDeviceExportLogObservable<T extends IDeviceExportLog> {
    observeByRequestId(requestId: string): Promise<Observable<T, Error>>;
}
//# sourceMappingURL=deviceExportLogModel.d.ts.map