import { IDevice } from '../deviceModel';
export interface IDeviceDebugPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceDebug {
    uid: string;
    deviceIdentityHash: string;
    appletEnabled: boolean;
    nativeEnabled: boolean;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceDebugModel {
    fetchByUid(uid: string): Promise<IDeviceDebug | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceDebug | null>;
    fetchLatestResolvedByDevice(device: IDevice): Promise<IDeviceDebug | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceDebug[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceDebugPropertyFilter): Promise<IDeviceDebug[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, appletEnabled: boolean, nativeEnabled: boolean, createdAt: Date): Promise<void>;
    markSucceeded(deviceDebugRow: IDeviceDebug, succeededAt: Date): Promise<void>;
    markFailed(deviceDebugRow: IDeviceDebug, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceDebugModel.d.ts.map