export interface IDeviceCounter {
    identityHash: string;
    beginAt: Date;
    endAt: Date;
    storedUntil: Date;
    counter: number;
}
export declare type IDeviceCounterModel = IDeviceCounterModelRead & IDeviceCounterModelWrite;
export interface IDeviceCounterModelRead {
    countScreenshotsInInterval(identityHash: string, since: Date, until: Date): Promise<number>;
    countScreenshotsSince(identityHash: string, since: Date): Promise<number>;
    countFailedActionsInInterval(identityHash: string, since: Date, until: Date): Promise<number>;
    countFailedActionsSince(identityHash: string, since: Date): Promise<number>;
}
export interface IDeviceCounterModelWrite {
    increaseScreenshotCounter(identityHash: string, now: Date): Promise<void>;
    increaseFailedActionCounter(identityHash: string, now: Date): Promise<void>;
}
//# sourceMappingURL=deviceCounterModel.d.ts.map