import { IDevice } from '../deviceModel';
export interface IDeviceBrightnessPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceBrightness {
    uid: string;
    deviceIdentityHash: string;
    brightness1: number;
    timeFrom1: string;
    brightness2: number;
    timeFrom2: string;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceBrightnessModel {
    fetchByUid(uid: string): Promise<IDeviceBrightness | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceBrightness | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceBrightness | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceBrightness[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceBrightness[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceBrightnessPropertyFilter): Promise<IDeviceBrightness[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, brightness1: number, timeFrom1: string, brightness2: number, timeFrom2: string, createdAt: Date): Promise<void>;
    markSucceeded(deviceBrightnessRow: IDeviceBrightness, succeededAt: Date): Promise<void>;
    markFailed(deviceBrightnessRow: IDeviceBrightness, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceBrightnessModel.d.ts.map