import { IDevice } from '../deviceModel';
export interface IDeviceAuthentication {
    deviceIdentityHash: string;
    authHash: string;
    createdAt: Date;
}
export interface IDeviceAuthenticationModel<TDeviceAuthentication extends IDeviceAuthentication> {
    fetchByDevice(device: IDevice): Promise<TDeviceAuthentication | null>;
    fetchByAuthHashStartsWith(authHash: string): Promise<TDeviceAuthentication | null>;
    create(device: IDevice, authHash: string, createdAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceAuthenticationModel.d.ts.map