import { IDevice } from '../deviceModel';
export interface IDeviceVolumePropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceVolume {
    uid: string;
    deviceIdentityHash: string;
    volume: number;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
}
export interface IDeviceVolumeModel {
    fetchByUid(uid: string): Promise<IDeviceVolume | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceVolume | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceVolume | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceVolume[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceVolume[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceVolumePropertyFilter): Promise<IDeviceVolume[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, volume: number, createdAt: Date): Promise<void>;
    markSucceeded(deviceVolumeRow: IDeviceVolume, succeededAt: Date): Promise<void>;
    markFailed(deviceVolumeRow: IDeviceVolume, failedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceVolumeModel.d.ts.map