import { IDevice } from '../../deviceModel';
import { IApplicationVersion } from '../../../Application/Version/applicationVersionModel';
export interface IDeviceApplicationVersionPropertyFilter {
    deviceIdentityHash?: string;
}
export interface IDeviceApplicationVersion {
    uid: string;
    deviceIdentityHash: string;
    applicationVersionUid: string;
    createdAt: Date;
    succeededAt: Date | null;
    failedAt: Date | null;
    postponedAt?: Date | null;
}
export interface IDeviceApplicationVersionModel {
    fetchByUid(uid: string): Promise<IDeviceApplicationVersion | null>;
    fetchByDevice(device: IDevice): Promise<IDeviceApplicationVersion | null>;
    fetchLatestSucceededByDevice(device: IDevice): Promise<IDeviceApplicationVersion | null>;
    fetchFailedByDeviceList(deviceList: IDevice[], from?: Date): Promise<IDeviceApplicationVersion[]>;
    fetchLatestListByDevices(devices: IDevice[]): Promise<IDeviceApplicationVersion[]>;
    fetchListByPropertyFilter(propertyFilter: IDeviceApplicationVersionPropertyFilter): Promise<IDeviceApplicationVersion[]>;
    countFailedByDevice(device: IDevice, from?: Date): Promise<number>;
    create(uid: string, device: IDevice, applicationVersion: IApplicationVersion, createdAt: Date): Promise<void>;
    markSucceeded(deviceApplicationVersionRow: IDeviceApplicationVersion, succeededAt: Date): Promise<void>;
    markFailed(deviceApplicationVersionRow: IDeviceApplicationVersion, failedAt: Date): Promise<void>;
    markPostponed(deviceApplicationVersionRow: IDeviceApplicationVersion, postponedAt: Date): Promise<void>;
}
//# sourceMappingURL=deviceApplicationVersionModel.d.ts.map