/// <reference types="lib.es2017.observable" />
import { IPaginator, PaginatorType } from '../../../MongoDB/paginatorHelper';
import { DeviceActionLogSortIndices } from '../../../Mongo/Device/ActionLog/deviceActionLogModel';
import { IOriginator } from '../../Originator/originator';
import { IDevice } from '../deviceModel';
import ApplicationType from '../../Application/ApplicationType';
import { ResolutionItem } from '@signageos/common-types/dist/Device/Resolution/ResolutionList';
import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import VideoOrientation from '@signageos/common-types/dist/Device/Resolution/VideoOrientation';
import { InputSource } from '@signageos/common-types/dist/Device/Input/InputSource';
import ITimer from './ITimer';
import { IConfigValues } from '../Configuration/deviceConfigurationModel';
import { FinishEventType } from '@signageos/common-types/dist/Timing/FinishEventType';
import { TelemetryCheckIntervals } from '@signageos/common-types/dist/Device/MonitoringLog/TelemetryIntervals';
import { AutoRecoveryDisabled, AutoRecoveryEnabled, PeerRecoveryDisabled, PeerRecoveryEnabled } from '@signageos/common-types/dist/Device/ActionLog/Recovery';
import { DeviceProvisioningRecipeStatus } from '@signageos/common-types/dist/Device/ProvisioningRecipe/deviceProvisioningRecipe';
export declare enum DeviceActionType {
    SET_APPLICATION_VERSION = "SET_APPLICATION_VERSION",
    SET_VOLUME = "SET_VOLUME",
    SET_RM_SERVER = "SET_RM_SERVER",
    SET_BRIGHTNESS = "SET_BRIGHTNESS",
    RECONNECT = "RECONNECT",
    UPDATE_CONFIGURATION = "UPDATE_CONFIGURATION",
    UPDATE_TIME = "UPDATE_TIME",
    SET_DEBUG = "SET_DEBUG",
    SET_FIRMWARE_VERSION = "SET_FIRMWARE_VERSION",
    INSTALL_PACKAGE = "INSTALL_PACKAGE",
    INSTALL_PACKAGE_FROM_URI = "INSTALL_PACKAGE_FROM_URI",
    UNINSTALL_PACKAGE = "UNINSTALL_PACKAGE",
    POWER_ACTION = "POWER_ACTION",
    SET_SCHEDULED_POWER_ACTION = "SET_SCHEDULED_POWER_ACTION",
    CANCEL_SCHEDULED_POWER_ACTION = "CANCEL_SCHEDULED_POWER_ACTION",
    SET_REMOTE_CONTROL = "SET_REMOTE_CONTROL",
    RESIZE = "RESIZE",
    PROVISION = "PROVISION",
    DEPROVISION = "DEPROVISION",
    UPDATE_NAME = "UPDATE_NAME",
    BAN = "BAN",
    APPROVE = "APPROVE",
    CHANGE_SUBSCRIPTION_TYPE = "CHANGE_SUBSCRIPTION_TYPE",
    CREATE_TIMING = "CREATE_TIMING",
    UPDATE_TIMING = "UPDATE_TIMING",
    DELETE_TIMING = "DELETE_TIMING",
    SET_POLICY = "SET_POLICY",
    DELETE_POLICY = "DELETE_POLICY",
    SET_ORGANIZATION_TAGS = "SET_ORGANIZATION_TAGS",
    DELETE_ORGANIZATION_TAGS = "DELETE_ORGANIZATION_TAGS",
    SET_ORGANIZATION = "SET_ORGANIZATION",
    SET_DEVICE_APPLET_TEST_SUITE = "SET_DEVICE_APPLET_TEST_SUITE",
    SET_TEST_SUITE = "SET_TEST_SUITE",
    START_PACKAGE = "START_PACKAGE",
    SET_TIMER = "SET_TIMER",
    SET_PROPRIETARY_TIMER = "SET_PROPRIETARY_TIMER",
    SET_POWER_STATUS = "SET_POWER_STATUS",
    SET_INPUT_SOURCE = "SET_INPUT_SOURCE",
    SET_DISPLAY_BACKLIGHT = "SET_DISPLAY_BACKLIGHT",
    SET_DISPLAY_CONTRAST = "SET_DISPLAY_CONTRAST",
    SET_DISPLAY_SHARPNESS = "SET_DISPLAY_SHARPNESS",
    SET_DISPLAY_TEMPERATURE_CONTROL = "SET_DISPLAY_TEMPERATURE_CONTROL",
    SET_REMOTE_DESKTOP = "SET_REMOTE_DESKTOP",
    SET_AUTO_RECOVERY = "SET_AUTO_RECOVERY",
    SET_PEER_RECOVERY = "SET_PEER_RECOVERY",
    ENABLE_EXTENDED_TELEMETRY = "ENABLE_EXTENDED_TELEMETRY",
    DISABLE_EXTENDED_TELEMETRY = "DISABLE_EXTENDED_TELEMETRY",
    UPDATE_TELEMETRY_CHECK_INTERVAL = "UPDATE_TELEMETRY_CHECK_INTERVAL",
    PROVISIONING_RECIPE_STATUS_UPDATED = "PROVISIONING_RECIPE_STATUS_UPDATED",
    SET_VPN = "SET_VPN"
}
export declare type LogData = {
    [DeviceActionType.SET_APPLICATION_VERSION]: {
        applicationType: ApplicationType;
        version: string;
    };
    [DeviceActionType.SET_VOLUME]: {
        volume: number;
    };
    [DeviceActionType.SET_RM_SERVER]: {
        rmServerUrl: string | null;
    };
    [DeviceActionType.SET_BRIGHTNESS]: {
        brightness1: number;
        brightness2: number;
        timeFrom1: string;
        timeFrom2: string;
    };
    [DeviceActionType.RECONNECT]: Record<string, never>;
    [DeviceActionType.UPDATE_CONFIGURATION]: IConfigValues;
    [DeviceActionType.UPDATE_TIME]: {
        timestamp: number;
        timezone: string | null;
        ntpServer?: string;
    };
    [DeviceActionType.SET_DEBUG]: {
        appletEnabled: boolean;
        nativeEnabled: boolean;
    };
    [DeviceActionType.SET_FIRMWARE_VERSION]: {
        version: string;
    };
    [DeviceActionType.INSTALL_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
        buildHash: string;
        version: string;
        build: string | null;
        /** null is allowed for historical reason. The specific data are defined in common-types */
        specs: object | null;
    };
    [DeviceActionType.INSTALL_PACKAGE_FROM_URI]: {
        /** null is allowed for historical data. It should be only "tizen" as default */
        applicationType: ApplicationType | null;
        packageUri: string;
        /** The specific data ara defined in common-types for every applicationType */
        specs: object | null;
    };
    [DeviceActionType.UNINSTALL_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
        specs: object;
    };
    [DeviceActionType.POWER_ACTION]: {
        powerType: string;
    };
    [DeviceActionType.SET_SCHEDULED_POWER_ACTION]: {
        powerType: string;
        weekdays: string[];
        time: string;
    };
    [DeviceActionType.CANCEL_SCHEDULED_POWER_ACTION]: {
        scheduledPowerActionUid: string;
    };
    [DeviceActionType.SET_VPN]: {
        enabled: boolean;
    };
    [DeviceActionType.SET_REMOTE_CONTROL]: {
        enabled: boolean;
    };
    [DeviceActionType.RESIZE]: {
        resolution: ResolutionItem;
        orientation: Orientation;
        videoOrientation?: VideoOrientation;
    };
    [DeviceActionType.PROVISION]: {
        verificationHash: string;
    };
    [DeviceActionType.DEPROVISION]: {
        verificationHash: string;
    };
    [DeviceActionType.UPDATE_NAME]: {
        name: string;
    };
    [DeviceActionType.BAN]: Record<string, never>;
    [DeviceActionType.APPROVE]: Record<string, never>;
    [DeviceActionType.CHANGE_SUBSCRIPTION_TYPE]: {
        subscriptionType: string | null;
    };
    [DeviceActionType.CREATE_TIMING]: {
        appletUid: string;
        appletVersion: string;
        startsAt: Date;
        endsAt: Date;
        configuration: Record<string, unknown>;
        finishEvent: {
            type: FinishEventType;
            data?: any;
        };
        position: number;
    };
    [DeviceActionType.UPDATE_TIMING]: {
        appletUid: string;
        appletVersion: string | undefined;
        startsAt: Date | undefined;
        endsAt: Date | undefined;
        configuration: Record<string, unknown> | undefined;
        configurationSet: Record<string, unknown> | undefined;
        configurationRemoveKeys: string[] | undefined;
        finishEvent: {
            type: FinishEventType | undefined;
            data?: any | undefined;
        } | undefined;
        position: number | undefined;
    };
    [DeviceActionType.DELETE_TIMING]: {
        uid: string;
        appletUid: string;
        appletVersion: string;
    };
    [DeviceActionType.SET_DEVICE_APPLET_TEST_SUITE]: {
        appletUid: string;
        appletVersion: string;
        tests: string[];
    };
    [DeviceActionType.SET_TEST_SUITE]: {
        tests: string[];
    };
    [DeviceActionType.START_PACKAGE]: {
        packageName: string;
        applicationType: ApplicationType;
    };
    [DeviceActionType.SET_TIMER]: ITimer;
    [DeviceActionType.SET_PROPRIETARY_TIMER]: ITimer;
    [DeviceActionType.SET_POWER_STATUS]: {
        turnedOn: boolean;
    };
    [DeviceActionType.SET_INPUT_SOURCE]: {
        inputSource: InputSource;
    };
    [DeviceActionType.SET_DISPLAY_BACKLIGHT]: {
        /** Value in range 0-100 */
        backlight: number;
    };
    [DeviceActionType.SET_DISPLAY_CONTRAST]: {
        /** Value in range 0-100 */
        contrast: number;
    };
    [DeviceActionType.SET_DISPLAY_SHARPNESS]: {
        /** Value in range 0-100 */
        sharpness: number;
    };
    [DeviceActionType.SET_DISPLAY_TEMPERATURE_CONTROL]: {
        /** Maximum temperature while display is keeping turned on. Otherwise, it's usually turned of or switched to power saving mode */
        maxTemperature: number;
    };
    [DeviceActionType.SET_REMOTE_DESKTOP]: {
        enabled: boolean;
        /** URL where the remote desktop will be available (usually for limited amount of time) */
        remoteDesktopUri?: string;
    };
    [DeviceActionType.SET_POLICY]: {
        policyUid: string;
        priority: number;
    };
    [DeviceActionType.DELETE_POLICY]: {
        policyUid: string;
    };
    [DeviceActionType.SET_ORGANIZATION_TAGS]: {
        deviceIdentityHash: string;
        tagUids: string[];
    };
    [DeviceActionType.DELETE_ORGANIZATION_TAGS]: {
        deviceIdentityHash: string;
        tagUids: string[];
    };
    [DeviceActionType.SET_ORGANIZATION]: {
        organizationUid: string;
    };
    [DeviceActionType.SET_AUTO_RECOVERY]: AutoRecoveryEnabled | AutoRecoveryDisabled;
    [DeviceActionType.SET_PEER_RECOVERY]: PeerRecoveryEnabled | PeerRecoveryDisabled;
    [DeviceActionType.ENABLE_EXTENDED_TELEMETRY]: {
        deviceIdentityHash: string;
        duration: number;
    };
    [DeviceActionType.DISABLE_EXTENDED_TELEMETRY]: {
        deviceIdentityHash: string;
    };
    [DeviceActionType.UPDATE_TELEMETRY_CHECK_INTERVAL]: TelemetryCheckIntervals;
    [DeviceActionType.PROVISIONING_RECIPE_STATUS_UPDATED]: {
        status: DeviceProvisioningRecipeStatus.APPLIED;
        provisioningRecipeUid: string;
    };
};
export interface IDeviceActionLog<T extends DeviceActionType> {
    id: string;
    uid: string;
    requestId: string;
    type: T;
    deviceIdentityHash: string;
    createdAt: Date;
    succeedAt: Date | null;
    failedAt: Date | null;
    updatedAt: Date | null;
    data: LogData[T];
    originator?: IOriginator;
}
export interface IDeviceActionLogCreate<T extends DeviceActionType> {
    uid: string;
    requestId: string;
    type: T;
    device: IDevice;
    createdAt: Date;
    data: LogData[T];
    originator?: IOriginator;
}
export interface IDeviceActionLogPropertyFilter<T extends DeviceActionType> {
    deviceIdentityHash?: string;
    uid?: string;
    type?: T;
    createdAt?: Date;
    succeedAt?: Date;
    failedAt?: Date;
    data?: LogData[T];
    requestId?: string;
    since?: Date;
    until?: Date;
    originator?: IOriginator;
    triggeredBy?: 'user' | 'api' | 'system';
}
export { IOriginator } from '../../Originator/originator';
export declare type IDeviceActionLogModel = IDeviceActionLogModelRead & IDeviceActionLogModelWrite & IDeviceActionLogModelObservable;
export interface IDeviceActionLogModelRead {
    fetchByUid<T extends DeviceActionType>(uid: string): Promise<IDeviceActionLog<T> | null>;
    fetchByDevice<T extends DeviceActionType>(device: IDevice): Promise<IDeviceActionLog<T> | null>;
    fetchByUidAndType<T extends DeviceActionType>(uid: string, type: T): Promise<IDeviceActionLog<T> | null>;
    fetchListByIdentityHash(deviceIdentityHash: string, offset?: number, limit?: number): Promise<IDeviceActionLog<DeviceActionType>[]>;
    fetchLatestSucceededByDevice<T extends DeviceActionType>(device: IDevice, type: T): Promise<IDeviceActionLog<T> | null>;
    fetchFailedByDeviceList<T extends DeviceActionType>(deviceList: IDevice[], type: T, from?: Date): Promise<IDeviceActionLog<T>[]>;
    fetchListByDevices<T extends DeviceActionType>(devices: IDevice[], type: T): Promise<IDeviceActionLog<T>[]>;
    fetchLatestListByDevices<T extends DeviceActionType>(devices: IDevice[], type: T, limit?: number): Promise<IDeviceActionLog<T>[]>;
    fetchLatestGroupedSucceededList<T extends DeviceActionType, K extends string & keyof LogData[T]>(device: IDevice, type: T, dataPropertyName: K): Promise<IDeviceActionLog<T>[]>;
    fetchListByPropertyFilter<T extends DeviceActionType>(propertyFilter: IDeviceActionLogPropertyFilter<T>, type: T): Promise<IDeviceActionLog<T>[]>;
    fetchListByIdentityHashAndPropertyFilter(deviceIdentityHash: string, propertyFilter: IDeviceActionLogPropertyFilter<DeviceActionType>, offset?: number, limit?: number): Promise<{
        actionLog: IDeviceActionLog<DeviceActionType>[];
        totalCount: number;
    }>;
    fetchLatestResolvedByDevice<T extends DeviceActionType>(device: IDevice, type: T): Promise<IDeviceActionLog<T> | null>;
    fetchListByDeviceAndStatus<T extends DeviceActionType>(device: IDevice, type: T, status?: string, limit?: number): Promise<IDeviceActionLog<T>[]>;
    fetchLatestByDevice<T extends DeviceActionType>(device: IDevice, type: T): Promise<IDeviceActionLog<T> | null>;
    fetchListByDevice<T extends DeviceActionType>(device: IDevice, type: T, filter?: IPaginator<DeviceActionLogSortIndices, PaginatorType>): Promise<IDeviceActionLog<T>[]>;
    countFailedByDevice<T extends DeviceActionType>(device: IDevice, type: T, from?: Date): Promise<number>;
    fetchAllListByDevice<T extends DeviceActionType>(device: IDevice, filter?: IPaginator<DeviceActionLogSortIndices, PaginatorType>): Promise<IDeviceActionLog<T>[]>;
}
export interface IDeviceActionLogModelWrite {
    create<T extends DeviceActionType>(uid: IDeviceActionLogCreate<T>['uid'], requestId: IDeviceActionLogCreate<T>['requestId'], type: IDeviceActionLogCreate<T>['type'], device: IDeviceActionLogCreate<T>['device'], createdAt: IDeviceActionLogCreate<T>['createdAt'], data: IDeviceActionLogCreate<T>['data'], originator?: IDeviceActionLogCreate<T>['originator']): Promise<void>;
    markSucceed<T extends DeviceActionType>(deviceActionLogRow: IDeviceActionLog<T>, succeedAt: Date): Promise<void>;
    markFailed<T extends DeviceActionType>(deviceActionLogRow: IDeviceActionLog<T>, failedAt: Date): Promise<void>;
    updateData<T extends DeviceActionType>(deviceActionLogRow: IDeviceActionLog<T>, updatedData: LogData[T], updatedAt: Date): Promise<void>;
}
export interface IDeviceActionLogModelObservable {
    observeByDeviceAndTypeWithInitialData<T extends DeviceActionType>(device: IDevice, type: T): Promise<Observable<IDeviceActionLog<T>, Error>>;
}
//# sourceMappingURL=deviceActionLogModel.d.ts.map