import { DeviceFilter } from '@signageos/common-types/dist/Device/deviceFilter';
import { IModelCreatable } from '../../Lib/Model/IModelCreatable';
import { IModelReadable } from '../../Lib/Model/IModelReadable';
import { IModelUpdatable } from '../../Lib/Model/IModelUpdatable';
import { ICreatable, IEntity, IUpdatable } from '../../Lib/Model/model';
import { ICompany, SubscriptionType } from '../Organization/organizationModel';
import { IWhiteLabelSettings } from '../WhiteLabelSettings/whiteLabelSettingsModel';
import { IModelDeletable } from '../../Lib/Model/IModelDeletable';
/**
 * Relation to other entities CompanyNetwork -> Company -> Organization -> Device
 */
export interface ICompanyNetworkBase extends IEntity {
    /** Subscription type works as override for all organizations within the companies within the company network */
    subscriptionType: SubscriptionType;
    /** @deprecated use whiteLabelSettingsUids */
    whiteLabelSettingsUid?: IWhiteLabelSettings['uid'];
    whiteLabelSettingsUids: IWhiteLabelSettings['uid'][];
    /** This filter should be applied as device filter for fetching devices by the company network */
    deviceFilter?: Pick<DeviceFilter, 'brands' | 'applicationTypes'>;
    name?: string;
}
export declare type ICompanyNetwork = ICompanyNetworkBase & ICreatable & IUpdatable;
export interface AssignWhiteLabelSettingsArgs {
    companyNetwork: ICompanyNetwork;
    whiteLabelSettings: IWhiteLabelSettings;
    updatedAt: Date;
}
export interface UnassignWhiteLabelSettingsArgs {
    companyNetwork: ICompanyNetwork;
    whiteLabelSettings: IWhiteLabelSettings;
    updatedAt: Date;
}
export interface ICompanyNetworkModelRead extends IModelReadable<ICompanyNetwork> {
    fetchByWhiteLabelSettingsUid(whiteLabelSettingsUid: string): Promise<ICompanyNetwork | null>;
    fetchAll(): Promise<ICompanyNetwork[]>;
    /**
     * @param companyNetworkUids
     * @returns Array of allowed brands which are available for at least one company network or empty array when all brands are allowed
     */
    fetchBrandsByCompanyNetworks({ companyNetworkUids, }: {
        companyNetworkUids: NonNullable<ICompany['companyNetworkUids']>;
    }): Promise<NonNullable<DeviceFilter['brands']>>;
}
export interface ICompanyNetworkModelWrite extends IModelCreatable<ICompanyNetwork>, IModelUpdatable<ICompanyNetworkBase>, IModelDeletable<ICompanyNetwork> {
    assignWhiteLabelSettings({ companyNetwork, whiteLabelSettings, updatedAt }: AssignWhiteLabelSettingsArgs): Promise<void>;
    unassignWhiteLabelSettings({ companyNetwork, updatedAt }: UnassignWhiteLabelSettingsArgs): Promise<void>;
}
export declare type ICompanyNetworkModel = ICompanyNetworkModelRead & ICompanyNetworkModelWrite;
//# sourceMappingURL=companyNetworkModel.d.ts.map