import { DeleteResult, InsertOneResult } from 'mongodb';
import { ICreatable } from '../../Lib/Model/model';
export interface IBulkRequestedEvent extends ICreatable {
    requestUid: string;
    sourceUid: string;
    deviceIdentityHash: string;
}
export interface IBulkRequestedEventModelRead<A extends IBulkRequestedEvent> {
    fetchByUid(requestUid: string): Promise<A | null>;
    fetchOlderThan(dateTime: Date): Promise<IBulkRequestedEvent[]>;
}
export interface IBulkRequestedEventModelWrite<A extends IBulkRequestedEvent> {
    create(record: A): Promise<InsertOneResult<A>>;
    delete(requestUid: string): Promise<DeleteResult>;
}
//# sourceMappingURL=bulkRequestedEventModel.d.ts.map