import { IApplet } from '../appletModel';
export declare type EcmaScriptSyntaxError = {
    name: 'EcmaScriptSyntaxError';
    message: string;
    pos: number;
    loc: {
        line: number;
        column: number;
    };
    codeFrame: string;
};
export declare type IAppletVersion = IAppletVersionRequired | (IAppletVersionRequired & IAppletVersionOptional);
export declare type IFullAppletVersion = IAppletVersionRequired & IAppletVersionOptional;
export interface IAppletVersionRequired {
    id: any;
    appletUid: string;
    version: string;
    createdAt: Date;
    updatedAt: Date;
    publishedSince?: Date | null;
    entryFile?: string | null;
    buildRequestUid?: string | null;
    buildRequestedAt?: Date | null;
}
export interface IAppletVersionOptional {
    frontAppletVersion?: string | null;
    deprecatedSince?: Date | null;
    builtSince?: Date | null;
    buildFailedAt?: Date | null;
    buildError?: EcmaScriptSyntaxError | null;
}
export declare type IAppletVersionModel<TAppletVersion extends IAppletVersion, TApplet extends IApplet> = IAppletVersionModelRead<TAppletVersion, TApplet> & IAppletVersionModelWrite<TAppletVersion, TApplet>;
export interface IAppletVersionModelRead<TAppletVersion extends IAppletVersion, TApplet extends IApplet> {
    fetchById(id: any): Promise<TAppletVersion | null>;
    fetchByAppletAndVersion(applet: TApplet, version: string): Promise<TAppletVersion | null>;
    fetchBinaryByAppletAndVersion(applet: IApplet, version: string): Promise<string | undefined>;
    fetchListByApplet(applet: TApplet): Promise<TAppletVersion[]>;
    fetchLastByApplet(applet: TApplet): Promise<TAppletVersion | null>;
}
export interface IAppletVersionModelWrite<TAppletVersion extends IAppletVersion, TApplet extends IApplet> {
    create(applet: TApplet, version: string, binary: string | null, //Deprecation note: binary will be deleted in future, will be replace by entryFile.
    frontAppletVersion: string | null, createdAt: Date, entryFile?: string | null): Promise<void>;
    remove(appletVersionRow: TAppletVersion): Promise<void>;
    updateBinary(appletVersionRow: TAppletVersion, binary: string, updatedAt: Date): Promise<void>;
    updateEntryFile(appletVersionRow: TAppletVersion, entryFile: string, updatedAt: Date): Promise<void>;
    updateFrontAppletVersion(appletVersionRow: TAppletVersion, frontAppletVersion: string | null, updatedAt: Date): Promise<void>;
    markPublished(appletVersionRow: TAppletVersion, publishedSince: Date): Promise<void>;
    markBuildRequested(appletVersionRow: TAppletVersion, buildRequestUid: string, buildRequestedAt: Date): Promise<void>;
    markBuilt(appletVersionRow: TAppletVersion, builtSince: Date): Promise<void>;
    markBuildFailed(appletVersionRow: TAppletVersion, buildError: EcmaScriptSyntaxError, buildFailedAt: Date): Promise<void>;
    markDeprecated(appletVersionRow: TAppletVersion, deprecatedSince: Date): Promise<void>;
    unmarkDeprecated(appletVersionRow: TAppletVersion): Promise<void>;
}
//# sourceMappingURL=appletVersionModel.d.ts.map