/// <reference types="lib.es2017.observable" />
import { IRedisConnection } from '@signageos/lib/dist/Redis/redisConnectionFactory';
import IChanges from '../IChanges';
import IPartialChanges from '../IPartialChanges';
declare type IRedisChanges<TDocument, TIdentityProperty extends keyof TDocument> = IChanges<TDocument> | IPartialChanges<TDocument, TIdentityProperty>;
export declare function createOne<TDocument>(conn: IRedisConnection, key: string, value: TDocument): Promise<void>;
export declare function createOneWithExpiration<TDocument>(conn: IRedisConnection, key: string, value: TDocument, ttlSeconds: number): Promise<void>;
export declare function createAndAddToHash<TDocument>(conn: IRedisConnection, key: string, field: string, value: TDocument): Promise<void>;
export declare function setExpiration(conn: IRedisConnection, key: string, ttlSeconds: number): Promise<void>;
export declare function deleteOne(conn: IRedisConnection, key: string): Promise<void>;
export declare function deleteOneFromHash(conn: IRedisConnection, key: string, field: string): Promise<void>;
export declare function createAndIncrementInHash(conn: IRedisConnection, key: string, field: string, incrementAmount: number): Promise<void>;
export declare function getOne<TDocument>(conn: IRedisConnection, key: string): Promise<TDocument | null>;
export declare function getValuesOfHash<TDocument>(conn: IRedisConnection, key: string): Promise<TDocument[]>;
export declare function getAllOfHash<TDocument = {
    [key: string]: string;
}>(conn: IRedisConnection, key: string): Promise<TDocument>;
export declare function getMany<TDocument>(conn: IRedisConnection, keys: string[]): Promise<TDocument[]>;
export declare function getManyMapWithKeys<TDocument>(conn: IRedisConnection, keys: string[]): Promise<Map<string, TDocument>>;
export declare function flushAll(conn: IRedisConnection): Promise<void>;
export declare function getMoreByPattern<TDocument>(conn: IRedisConnection, keyPattern: string): Promise<TDocument[]>;
/**
 * Get all keys matching the pattern. It uses KEYS which is blocking and memory pressured variant.
 * Consider using scanKeysByPattern instead.
 */
export declare function getKeysByPattern(conn: IRedisConnection, keyPattern: string): Promise<string[]>;
export declare function updatePartialOne<TDocument, TIdentityProperty extends keyof TDocument>(conn: IRedisConnection, key: string, value: Partial<TDocument> & Pick<TDocument, TIdentityProperty>): Promise<void>;
export declare function updateOnDelete<TDocument>(conn: IRedisConnection, key: string, old_val: TDocument): Promise<void>;
export declare function updateOne<TDocument>(conn: IRedisConnection, key: string, value: TDocument): Promise<void>;
export declare function observe<TDocument, TIdentityProperty extends keyof TDocument>(conn: IRedisConnection, key: string): Observable<IRedisChanges<TDocument, TIdentityProperty>, Error>;
export declare const CURSOR_BEGINNING = "0";
export declare type ScanResult = {
    keys: string[];
    nextCursor: string;
};
/**
 * This version of getting keys is same as getKeysByPattern but it using SCAN instead of KEYS.
 * It's better to use for larger set of result keys. For shorter set is better to use KEYS instead.
 */
export declare function scanKeysByPattern(conn: IRedisConnection, keyPattern: string, options?: {
    cursor?: string;
    batchSize?: number;
    iterateToEnd?: boolean;
    iterationDelayMs?: number;
}): Promise<ScanResult>;
export declare function addToOrderedSet<TDocument>(conn: IRedisConnection, key: string, score: number, value: TDocument): Promise<void>;
export declare function countOrderedSet(conn: IRedisConnection, key: string, minScore: number, maxScore: number, minClassification?: '[' | '(', maxClassification?: ']' | ')'): Promise<number>;
export declare const set: <Value>(conn: IRedisConnection, key: string, value: Value) => Promise<void>;
export declare const exists: (conn: IRedisConnection, key: string) => Promise<boolean>;
export declare const increment: (conn: IRedisConnection, key: string) => Promise<void>;
export {};
//# sourceMappingURL=helper.d.ts.map