"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
/**
 * Enum used as number of redis database to be used for specific models subset.
 * To separate some logic from the rest of models.
 */
var Database;
(function (Database) {
    /** Default connection database used for all models */
    Database[Database["DEFAULT"] = 0] = "DEFAULT";
    /** Special database for models related to event sourcing, which is not anyhow related to platform logic */
    Database[Database["EVENT_SOURCING"] = 1] = "EVENT_SOURCING";
})(Database = exports.Database || (exports.Database = {}));
//# sourceMappingURL=databases.js.map