"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimingModel = void 0;
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const helper_1 = require("../helper");
const timingUidKeyPrefix = 'timing.timingUid';
function getTimingUidKey(uid) {
    return `${timingUidKeyPrefix}.${uid}`;
}
const timingDeviceIdentityHashKeyPrefix = 'timing.deviceIdentityHash';
function getTimingDeviceIdentityHashKey(deviceIdentityHash) {
    return `${timingDeviceIdentityHashKeyPrefix}.${deviceIdentityHash}`;
}
function computeTimingsStamp(timings) {
    return timings.reduce((stamp, timing, index) => {
        return stamp + (1 - 2 * (index % 2)) * timing.updatedAt.getTime();
    }, 0);
}
const createTimingModel = (conn, sourceModel) => {
    function updateTimingPartial(timingPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getTimingUidKey(timingPartial.uid), timingPartial);
            yield (0, helper_1.updatePartialOne)(conn, getTimingDeviceIdentityHashKey(timingPartial.deviceIdentityHash), timingPartial);
        });
    }
    return {
        create(_appletRow, deviceRow, values) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateTimingPartial({ uid: values.uid, deviceIdentityHash: deviceRow.identityHash });
            });
        },
        update(timingRow, _values) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateTimingPartial({
                    uid: timingRow.uid,
                    deviceIdentityHash: timingRow.deviceIdentityHash,
                });
            });
        },
        remove(timingRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateTimingPartial({
                    uid: timingRow.uid,
                    deviceIdentityHash: timingRow.deviceIdentityHash,
                });
            });
        },
        observeByUid(timingUid) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = getTimingUidKey(timingUid);
                const observable = (0, helper_1.observe)(conn, key);
                return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
                    const timing = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                        return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
                    }));
                    return {
                        old_val: { uid: changes.new_partial_val.uid },
                        new_val: timing,
                        clusterTime: changes.clusterTime,
                    };
                }));
            });
        },
        observeListByDevice(device) {
            return __awaiter(this, void 0, void 0, function* () {
                const key = getTimingDeviceIdentityHashKey(device.identityHash);
                const observable = (0, helper_1.observe)(conn, key);
                let lastStamp = Math.round(Math.random() * 1e6);
                return (0, helpers_1.asyncMap)(observable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchList({ devices: [device] });
                })).filter((timings) => {
                    const currentStamp = computeTimingsStamp(timings);
                    if (currentStamp !== lastStamp) {
                        lastStamp = currentStamp;
                        return true;
                    }
                    return false;
                });
            });
        },
    };
};
exports.createTimingModel = createTimingModel;
//# sourceMappingURL=timingModel.js.map